/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.xts;

import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.xts.Attribute;
import org.jboss.as.xts.Element;
import org.jboss.as.xts.Namespace;
import org.jboss.as.xts.XTSSubsystemAdd;
import org.jboss.as.xts.XTSSubsystemProviders;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class XTSExtension
implements Extension {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.xts");
    public static final String SUBSYSTEM_NAME = "xts";
    private static final XTSSubsystemParser parser = new XTSSubsystemParser();

    public void initialize(ExtensionContext context) {
        log.debug((Object)"Initializing XTS Extension");
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel(XTSSubsystemProviders.SUBSYSTEM);
        registration.registerOperationHandler("add", (OperationStepHandler)XTSSubsystemAdd.INSTANCE, XTSSubsystemProviders.SUBSYSTEM_ADD, false);
        registration.registerOperationHandler("describe", (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE, (DescriptionProvider)GenericSubsystemDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        subsystem.registerXMLElementWriter((XMLElementWriter)parser);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(Namespace.CURRENT.getUriString(), (XMLElementReader)parser);
    }

    private static ModelNode createEmptyAddOperation() {
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").add("subsystem", SUBSYSTEM_NAME);
        return subsystem;
    }

    static class XTSSubsystemParser
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>>,
    XMLElementWriter<SubsystemMarshallingContext> {
        XTSSubsystemParser() {
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            if (reader.getAttributeCount() > 0) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
            }
            ModelNode subsystem = XTSExtension.createEmptyAddOperation();
            list.add(subsystem);
            EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
            block6: while (reader.hasNext() && reader.nextTag() != 2) {
                switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case XTS_1_0: {
                        Element element = Element.forName(reader.getLocalName());
                        if (!encountered.add(element)) {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                        }
                        switch (element) {
                            case XTS_ENVIRONMENT: {
                                ModelNode model = XTSSubsystemParser.parseXTSEnvironmentElement(reader);
                                subsystem.get("xts-environment").set(model);
                                continue block6;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }

        static ModelNode parseXTSEnvironmentElement(XMLExtendedStreamReader reader) throws XMLStreamException {
            ModelNode store = new ModelNode();
            int count = reader.getAttributeCount();
            block3: for (int i = 0; i < count; ++i) {
                ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                String value = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case URL: {
                        store.get("url").set(value);
                        continue block3;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            return store;
        }

        public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
            context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
            ModelNode node = context.getModelNode();
            if (this.has(node, "xts-environment")) {
                writer.writeStartElement(Element.XTS_ENVIRONMENT.getLocalName());
                ModelNode xtsEnv = node.get("xts-environment");
                if (this.has(xtsEnv, "url")) {
                    this.writeAttribute(writer, Attribute.URL, xtsEnv.get("url"));
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }

        private boolean has(ModelNode node, String name) {
            return node.has(name) && node.get(name).isDefined();
        }

        private void writeAttribute(XMLExtendedStreamWriter writer, Attribute attr, ModelNode value) throws XMLStreamException {
            writer.writeAttribute(attr.getLocalName(), value.asString());
        }
    }
}

