/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote.protocol.versionone;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.deployment.DeploymentRepository;
import org.jboss.as.ejb3.deployment.EjbDeploymentInformation;
import org.jboss.as.ejb3.remote.protocol.versionone.EJBIdentifierBasedMessageHandler;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.remoting.PackedInteger;
import org.jboss.ejb.client.remoting.RemotingAttachments;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.MessageInputStream;
import org.xnio.IoUtils;

class SessionOpenRequestHandler
extends EJBIdentifierBasedMessageHandler {
    private static final Logger logger = Logger.getLogger(SessionOpenRequestHandler.class);
    private static final byte HEADER_SESSION_OPEN_RESPONSE = 2;
    private static final byte HEADER_EJB_NOT_STATEFUL = 13;
    private final ExecutorService executorService;

    SessionOpenRequestHandler(DeploymentRepository deploymentRepository, String marshallingStrategy, ExecutorService executorService) {
        super(deploymentRepository, marshallingStrategy);
        this.executorService = executorService;
    }

    @Override
    public void processMessage(Channel channel, MessageInputStream messageInputStream) throws IOException {
        String beanName;
        String distinctName;
        String moduleName;
        if (messageInputStream == null) {
            throw new IllegalArgumentException("Cannot read from null message inputstream");
        }
        DataInputStream dataInputStream = new DataInputStream((InputStream)messageInputStream);
        short invocationId = dataInputStream.readShort();
        String appName = dataInputStream.readUTF();
        EjbDeploymentInformation ejbDeploymentInformation = this.findEJB(appName, moduleName = dataInputStream.readUTF(), distinctName = dataInputStream.readUTF(), beanName = dataInputStream.readUTF());
        if (ejbDeploymentInformation == null) {
            this.writeNoSuchEJBFailureMessage(channel, invocationId, appName, moduleName, distinctName, beanName, null);
            return;
        }
        EJBComponent component = ejbDeploymentInformation.getEjbComponent();
        if (!(component instanceof StatefulSessionComponent)) {
            String failureMessage = "EJB " + beanName + " is not a Stateful Session bean in app: " + appName + " module: " + moduleName + " distinct name:" + distinctName;
            this.writeInvocationFailure(channel, (byte)13, invocationId, failureMessage);
            return;
        }
        RemotingAttachments attachments = this.readAttachments(dataInputStream);
        StatefulSessionComponent statefulSessionComponent = (StatefulSessionComponent)component;
        this.executorService.submit(new SessionIDGeneratorTask(statefulSessionComponent, channel, invocationId, attachments));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSessionId(Channel channel, short invocationId, SessionID sessionID, RemotingAttachments attachments) throws IOException {
        byte[] sessionIdBytes = sessionID.getEncodedForm();
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)channel.writeMessage());
        try {
            dataOutputStream.writeByte(2);
            dataOutputStream.writeShort(invocationId);
            PackedInteger.writePackedInteger((DataOutput)dataOutputStream, (int)sessionIdBytes.length);
            dataOutputStream.write(sessionIdBytes);
            this.writeAttachments(dataOutputStream, attachments);
        }
        finally {
            dataOutputStream.close();
        }
    }

    private class SessionIDGeneratorTask
    implements Runnable {
        private final StatefulSessionComponent statefulSessionComponent;
        private final Channel channel;
        private final short invocationId;
        private final RemotingAttachments attachments;

        SessionIDGeneratorTask(StatefulSessionComponent statefulSessionComponent, Channel channel, short invocationId, RemotingAttachments attachments) {
            this.statefulSessionComponent = statefulSessionComponent;
            this.invocationId = invocationId;
            this.attachments = attachments;
            this.channel = channel;
        }

        @Override
        public void run() {
            try {
                SessionID sessionID;
                try {
                    sessionID = this.statefulSessionComponent.createSession();
                }
                catch (Throwable t) {
                    SessionOpenRequestHandler.this.writeException(this.channel, this.invocationId, t, this.attachments);
                    return;
                }
                SessionOpenRequestHandler.this.writeSessionId(this.channel, this.invocationId, sessionID, this.attachments);
            }
            catch (IOException ioe) {
                logger.error((Object)("IOException while generating session id for invocation id: " + this.invocationId + " on channel " + this.channel), (Throwable)ioe);
                IoUtils.safeClose((Closeable)this.channel);
                return;
            }
        }
    }
}

