/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc2;

import java.sql.SQLException;
import javax.ejb.DuplicateKeyException;
import org.jboss.as.cmp.jdbc.bridge.JDBCAbstractCMRFieldBridge;
import org.jboss.as.cmp.jdbc2.bridge.JDBCCMRFieldBridge2;
import org.jboss.as.cmp.jdbc2.bridge.JDBCEntityBridge2;
import org.jboss.as.cmp.jdbc2.schema.Cache;
import org.jboss.as.cmp.jdbc2.schema.EntityTable;

public class PersistentContext {
    private final EntityTable.Row row;
    private final JDBCCMRFieldBridge2.FieldState[] cmrStates;

    public PersistentContext(JDBCEntityBridge2 entity, EntityTable.Row row) {
        this.row = row;
        JDBCAbstractCMRFieldBridge[] cmrFields = entity.getCMRFields();
        this.cmrStates = cmrFields != null ? new JDBCCMRFieldBridge2.FieldState[cmrFields.length] : null;
    }

    public Object getFieldValue(int rowIndex) {
        return this.row.getFieldValue(rowIndex);
    }

    public void setFieldValue(int rowIndex, Object value) {
        this.row.setFieldValue(rowIndex, value);
    }

    public void setPk(Object pk) throws DuplicateKeyException {
        if (pk == null) {
            throw new IllegalArgumentException("Primary key is null!");
        }
        this.row.insert(pk);
    }

    public boolean isDirty() {
        return this.row.isDirty();
    }

    public void setDirty() {
        this.row.setDirty();
    }

    public void setDirtyRelations() {
        this.row.setDirtyRelations();
    }

    public void remove() {
        this.row.delete();
    }

    public JDBCCMRFieldBridge2.FieldState getCMRState(int cmrIndex) {
        return this.cmrStates[cmrIndex];
    }

    public void setCMRState(int cmrIndex, JDBCCMRFieldBridge2.FieldState state) {
        this.cmrStates[cmrIndex] = state;
    }

    public void loadCachedRelations(int cmrIndex, Cache.CacheLoader loader) {
        this.row.loadCachedRelations(cmrIndex, loader);
    }

    public void cacheRelations(int cmrIndex, Cache.CacheLoader loader) {
        this.row.cacheRelations(cmrIndex, loader);
    }

    public void flush() throws SQLException, DuplicateKeyException {
        this.row.flush();
    }

    public void nullForeignKey(EntityTable.ForeignKeyConstraint constraint) {
        this.row.nullForeignKey(constraint);
    }

    public void nonNullForeignKey(EntityTable.ForeignKeyConstraint constraint) {
        this.row.nonNullForeignKey(constraint);
    }
}

