/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.keygenerator.hilo;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.jboss.as.cmp.jdbc.JDBCUtil;
import org.jboss.as.cmp.jdbc.SQLUtil;
import org.jboss.as.cmp.keygenerator.KeyGenerator;
import org.jboss.as.cmp.keygenerator.KeyGeneratorFactory;
import org.jboss.as.cmp.keygenerator.hilo.HiLoKeyGenerator;
import org.jboss.logging.Logger;

public class HiLoKeyGeneratorFactory
implements KeyGeneratorFactory,
Serializable {
    private static final Logger log = Logger.getLogger(HiLoKeyGeneratorFactory.class);
    private String dataSourceJndi;
    private transient DataSource ds;
    private transient TransactionManager tm;
    private String jndiName;
    private String tableName;
    private String sequenceColumn;
    private String sequenceName;
    private String idColumnName;
    private String createTableDdl;
    private String selectHiSql;
    private long blockSize;
    private boolean createTable = true;
    private boolean dropTable;

    @Override
    public String getFactoryName() {
        return this.jndiName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) throws Exception {
        this.tableName = tableName;
    }

    public String getSequenceColumn() {
        return this.sequenceColumn;
    }

    public void setSequenceColumn(String sequenceColumn) {
        this.sequenceColumn = sequenceColumn;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
    }

    public String getIdColumnName() {
        return this.idColumnName;
    }

    public void setIdColumnName(String idColumnName) {
        this.idColumnName = idColumnName;
    }

    public String getCreateTableDdl() {
        return this.createTableDdl;
    }

    public void setCreateTableDdl(String createTableDdl) {
        this.createTableDdl = createTableDdl;
    }

    public String getSelectHiSql() {
        return this.selectHiSql;
    }

    public void setSelectHiSql(String selectHiSql) {
        this.selectHiSql = selectHiSql;
    }

    public long getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(long blockSize) {
        this.blockSize = blockSize;
    }

    public boolean isCreateTable() {
        return this.createTable;
    }

    public void setCreateTable(boolean createTable) {
        this.createTable = createTable;
    }

    public boolean isDropTable() {
        return this.dropTable;
    }

    public void setDropTable(boolean dropTable) {
        this.dropTable = dropTable;
    }

    @Override
    public KeyGenerator getKeyGenerator() throws Exception {
        return new HiLoKeyGenerator(this.ds, this.tableName, this.sequenceColumn, this.sequenceName, this.idColumnName, this.selectHiSql, this.blockSize, this.tm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSequence(String tableName, String sequenceColumn, String sequenceName, String idColumnName) throws SQLException {
        ResultSet rs;
        Statement st;
        Connection con;
        block8: {
            if (this.createTable) {
                this.createTableIfNotExists(tableName);
            }
            con = null;
            st = null;
            rs = null;
            try {
                String sql = "select " + idColumnName + " from " + tableName + " where " + sequenceColumn + "='" + sequenceName + "'";
                log.debug((Object)("Executing SQL: " + sql));
                con = this.ds.getConnection();
                st = con.createStatement();
                rs = st.executeQuery(sql);
                if (!rs.next()) {
                    sql = "insert into " + tableName + "(" + sequenceColumn + ", " + idColumnName + ") values ('" + sequenceName + "', 0)";
                    log.debug((Object)("Executing SQL: " + sql));
                    Statement insertSt = con.createStatement();
                    try {
                        int i = insertSt.executeUpdate(sql);
                        if (i != 1) {
                            throw new SQLException("Expected one updated row but got: " + i);
                        }
                        break block8;
                    }
                    finally {
                        JDBCUtil.safeClose(insertSt);
                    }
                }
                HiLoKeyGenerator.setHighestHi(rs.getLong(1));
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(rs);
                JDBCUtil.safeClose(st);
                JDBCUtil.safeClose(con);
                throw throwable;
            }
        }
        JDBCUtil.safeClose(rs);
        JDBCUtil.safeClose(st);
        JDBCUtil.safeClose(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTableIfNotExists(String tableName) throws SQLException {
        Connection con = null;
        Statement st = null;
        try {
            if (!SQLUtil.tableExists(tableName, this.ds)) {
                log.debug((Object)("Executing DDL: " + this.createTableDdl));
                con = this.ds.getConnection();
                st = con.createStatement();
                st.executeUpdate(this.createTableDdl);
            }
        }
        finally {
            JDBCUtil.safeClose(st);
            JDBCUtil.safeClose(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropTableIfExists(String tableName) throws SQLException {
        Connection con = null;
        Statement st = null;
        try {
            if (SQLUtil.tableExists(tableName, this.ds)) {
                String ddl = "drop table " + tableName;
                log.debug((Object)("Executing DDL: " + ddl));
                con = this.ds.getConnection();
                st = con.createStatement();
                st.executeUpdate(ddl);
            }
        }
        finally {
            JDBCUtil.safeClose(st);
            JDBCUtil.safeClose(con);
        }
    }

    private DataSource lookupDataSource(String dataSource) throws Exception {
        try {
            return (DataSource)new InitialContext().lookup(dataSource);
        }
        catch (NamingException e) {
            throw new Exception("Failed to lookup data source: " + dataSource);
        }
    }
}

