/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.List;
import javax.management.MBeanServer;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.protocols.UNICAST;
import org.jgroups.protocols.UNICAST2;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

public class UnicastTestSimple
extends ReceiverAdapter {
    private JChannel channel;
    private final MyReceiver receiver = new MyReceiver();
    static final String groupname = "UnicastTestSimpleGroup";
    private boolean oob = false;

    public void init(String props, String name) throws Exception {
        this.channel = new JChannel(props);
        if (name != null) {
            this.channel.setName(name);
        }
        this.channel.connect(groupname);
        this.channel.setReceiver(this.receiver);
        try {
            MBeanServer server = Util.getMBeanServer();
            JmxConfigurator.registerChannel(this.channel, server, "jgroups", this.channel.getClusterName(), true);
        }
        catch (Throwable ex) {
            System.err.println("registering the channel in JMX failed: " + ex);
        }
    }

    public void eventLoop() throws Exception {
        int count = 1;
        block10: while (true) {
            System.out.print("[1] Send msgs [2] Print view [3] Print conns [4] Trash conn [5] Trash all conns\n[o] Toggle OOB (" + this.oob + ")\n[q] Quit\n");
            System.out.flush();
            int c = System.in.read();
            switch (c) {
                case -1: {
                    continue block10;
                }
                case 49: {
                    this.sendMessage(count++);
                    continue block10;
                }
                case 50: {
                    this.printView();
                    continue block10;
                }
                case 51: {
                    this.printConnections();
                    continue block10;
                }
                case 52: {
                    this.removeConnection();
                    continue block10;
                }
                case 53: {
                    this.removeAllConnections();
                    continue block10;
                }
                case 111: {
                    this.oob = !this.oob;
                    System.out.println("oob=" + this.oob);
                    continue block10;
                }
                case 113: {
                    this.channel.close();
                    return;
                }
            }
        }
    }

    private void printConnections() {
        Protocol prot = this.channel.getProtocolStack().findProtocol(UNICAST.class, UNICAST2.class);
        if (prot instanceof UNICAST) {
            System.out.println(((UNICAST)prot).printConnections());
        } else if (prot instanceof UNICAST2) {
            System.out.println(((UNICAST2)prot).printConnections());
        }
    }

    private void removeConnection() {
        Address member = this.getReceiver();
        if (member != null) {
            Protocol prot = this.channel.getProtocolStack().findProtocol(UNICAST.class, UNICAST2.class);
            if (prot instanceof UNICAST) {
                ((UNICAST)prot).removeConnection(member);
            } else if (prot instanceof UNICAST2) {
                ((UNICAST2)prot).removeConnection(member);
            }
        }
    }

    private void removeAllConnections() {
        Protocol prot = this.channel.getProtocolStack().findProtocol(UNICAST.class, UNICAST2.class);
        if (prot instanceof UNICAST) {
            ((UNICAST)prot).removeAllConnections();
        } else if (prot instanceof UNICAST2) {
            ((UNICAST2)prot).removeAllConnections();
        }
    }

    void sendMessage(int val) throws Exception {
        Address destination = this.getReceiver();
        if (destination == null) {
            System.err.println("UnicastTest.sendMessages(): receiver is null, cannot send messages");
            return;
        }
        String str = "hello-" + val;
        Message msg = new Message(destination, null, str);
        if (this.oob) {
            msg.setFlag((byte)1);
        }
        System.out.println("sending " + str + " to " + destination);
        this.channel.send(msg);
    }

    void printView() {
        System.out.println("\n-- view: " + this.channel.getView() + '\n');
        try {
            System.in.skip(System.in.available());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Address getReceiver() {
        List<Address> mbrs = null;
        try {
            mbrs = this.channel.getView().getMembers();
            System.out.println("pick receiver from the following members:");
            int i = 0;
            for (Address mbr : mbrs) {
                if (mbr.equals(this.channel.getAddress())) {
                    System.out.println("[" + i + "]: " + mbr + " (self)");
                } else {
                    System.out.println("[" + i + "]: " + mbr);
                }
                ++i;
            }
            System.out.flush();
            System.in.skip(System.in.available());
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String tmp = reader.readLine().trim();
            int index = Integer.parseInt(tmp);
            return mbrs.get(index);
        }
        catch (Exception e) {
            System.err.println("UnicastTest.getReceiver(): " + e);
            return null;
        }
    }

    public static void main(String[] args) {
        String props = null;
        String name = null;
        for (int i = 0; i < args.length; ++i) {
            if ("-props".equals(args[i])) {
                props = args[++i];
                continue;
            }
            if ("-name".equals(args[i])) {
                name = args[++i];
                continue;
            }
            UnicastTestSimple.help();
            return;
        }
        try {
            UnicastTestSimple test = new UnicastTestSimple();
            test.init(props, name);
            test.eventLoop();
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    static void help() {
        System.out.println("UnicastTest [-help] [-props <props>] [-sleep <time in ms between msg sends] [-exit_on_end] [-busy-sleep] [-name name]");
    }

    private static class MyReceiver
    extends ReceiverAdapter {
        private MyReceiver() {
        }

        @Override
        public void receive(Message msg) {
            System.out.println("msg from " + msg.getSrc() + ": " + msg.getObject());
        }

        @Override
        public void viewAccepted(View new_view) {
            System.out.println("** view: " + new_view);
        }
    }
}

