/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import java.net.UnknownHostException;
import java.util.List;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.webservices.WSLogger;
import org.jboss.as.webservices.config.ServerConfigImpl;
import org.jboss.as.webservices.dmr.WSDeploymentActivator;
import org.jboss.as.webservices.service.EndpointRegistryService;
import org.jboss.as.webservices.service.ServerConfigService;
import org.jboss.as.webservices.util.ModuleClassLoaderProvider;
import org.jboss.as.webservices.util.WSServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;

public class WSSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    static final WSSubsystemAdd INSTANCE = new WSSubsystemAdd();
    private final ParametersValidator configValidator = new ParametersValidator();

    private WSSubsystemAdd() {
        this.configValidator.registerValidator("wsdl-host", (ParameterValidator)new ModelTypeValidator(ModelType.STRING, true, true));
        this.configValidator.registerValidator("modify-wsdl-address", (ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN));
        this.configValidator.registerValidator("wsdl-port", (ParameterValidator)new ModelTypeValidator(ModelType.INT, true, true));
        this.configValidator.registerValidator("wsdl-secure-port", (ParameterValidator)new ModelTypeValidator(ModelType.INT, true, true));
    }

    protected void populateModel(ModelNode operation, ModelNode submodel) throws OperationFailedException {
        boolean appclient;
        if (operation.has("appclient")) {
            submodel.get("appclient").set(operation.require("appclient"));
            appclient = operation.require("appclient").asBoolean();
        } else {
            appclient = false;
        }
        if (!appclient) {
            this.configValidator.validate(operation);
            submodel.get("modify-wsdl-address").set(operation.require("modify-wsdl-address"));
            submodel.get("wsdl-host").setExpression(operation.require("wsdl-host").asString());
            if (operation.has("wsdl-port")) {
                submodel.get("wsdl-port").set(operation.require("wsdl-port"));
            }
            if (operation.has("wsdl-secure-port")) {
                submodel.get("wsdl-secure-port").set(operation.require("wsdl-secure-port"));
            }
            submodel.get("endpoint-config").setEmptyObject();
            submodel.get("endpoint").setEmptyObject();
        }
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        WSLogger.ROOT_LOGGER.activatingWebservicesExtension();
        ModuleClassLoaderProvider.register();
        final boolean appclient = model.has("appclient") ? model.get("appclient").asBoolean(false) : false;
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                WSDeploymentActivator.activate(processorTarget, appclient);
            }
        }, OperationContext.Stage.RUNTIME);
        if (!appclient) {
            WSServices.saveContainerRegistry(context.getServiceRegistry(false));
            ServiceTarget serviceTarget = context.getServiceTarget();
            ServerConfigImpl serverConfig = WSSubsystemAdd.createServerConfig(model);
            newControllers.add(ServerConfigService.install(serviceTarget, serverConfig, new ServiceListener[]{verificationHandler}));
            newControllers.add(EndpointRegistryService.install(serviceTarget, new ServiceListener[]{verificationHandler}));
        }
    }

    private static ServerConfigImpl createServerConfig(ModelNode configuration) {
        ServerConfigImpl config = ServerConfigImpl.getInstance();
        try {
            ModelNode wsdlHost = configuration.require("wsdl-host").resolve();
            config.setWebServiceHost(wsdlHost.asString());
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        config.setModifySOAPAddress(configuration.require("modify-wsdl-address").asBoolean());
        if (configuration.hasDefined("wsdl-port")) {
            config.setWebServicePort(configuration.require("wsdl-port").asInt());
        }
        if (configuration.hasDefined("wsdl-secure-port")) {
            config.setWebServiceSecurePort(configuration.require("wsdl-secure-port").asInt());
        }
        return config;
    }
}

