/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.ConnectorRefsAttribute;
import org.jboss.as.messaging.MessagingMessages;

public enum Element {
    UNKNOWN((String)null),
    ACCEPTORS("acceptors"),
    ADDRESS(Element.getAttributeDefinitions(new AttributeDefinition[]{CommonAttributes.QUEUE_ADDRESS, CommonAttributes.DIVERT_ADDRESS, CommonAttributes.GROUPING_HANDLER_ADDRESS, CommonAttributes.CLUSTER_CONNECTION_ADDRESS})),
    ADDRESS_SETTINGS("address-settings"),
    ALLOW_FAILBACK((AttributeDefinition)CommonAttributes.ALLOW_FAILBACK),
    ASYNC_CONNECTION_EXECUTION_ENABLED((AttributeDefinition)CommonAttributes.ASYNC_CONNECTION_EXECUTION_ENABLED),
    BACKUP((AttributeDefinition)CommonAttributes.BACKUP),
    BINDINGS_DIRECTORY("bindings-directory"),
    BRIDGE("bridge"),
    BRIDGES("bridges"),
    BROADCAST_GROUP("broadcast-group"),
    BROADCAST_GROUPS("broadcast-groups"),
    BROADCAST_PERIOD((AttributeDefinition)CommonAttributes.BROADCAST_PERIOD),
    CLASS_NAME("class-name"),
    CLUSTERED((AttributeDefinition)CommonAttributes.CLUSTERED),
    CLUSTER_CONNECTION("cluster-connection"),
    CLUSTER_CONNECTIONS("cluster-connections"),
    CLUSTER_PASSWORD((AttributeDefinition)CommonAttributes.CLUSTER_PASSWORD),
    CLUSTER_USER((AttributeDefinition)CommonAttributes.CLUSTER_USER),
    CONNECTION_TTL_OVERRIDE((AttributeDefinition)CommonAttributes.CONNECTION_TTL_OVERRIDE),
    CONNECTOR_SERVICE("connector-service"),
    CONNECTOR_SERVICES("connector-services"),
    CONNECTOR_REF(Element.getConnectorRefDefinitions()),
    CORE_QUEUES("core-queues"),
    CREATE_BINDINGS_DIR((AttributeDefinition)CommonAttributes.CREATE_BINDINGS_DIR),
    CREATE_JOURNAL_DIR((AttributeDefinition)CommonAttributes.CREATE_JOURNAL_DIR),
    DISCOVERY_GROUP("discovery-group"),
    DISCOVERY_GROUPS("discovery-groups"),
    DIVERT("divert"),
    DIVERTS("diverts"),
    DURABLE((AttributeDefinition)CommonAttributes.DURABLE),
    EXCLUSIVE((AttributeDefinition)CommonAttributes.EXCLUSIVE),
    FAILBACK_DELAY((AttributeDefinition)CommonAttributes.FAILBACK_DELAY),
    FAILOVER_ON_SHUTDOWN((AttributeDefinition)CommonAttributes.FAILOVER_ON_SHUTDOWN),
    FILE_DEPLOYMENT_ENABLED("file-deployment-enabled"),
    FORWARDING_ADDRESS(Element.getForwardingAddressDefinitions()),
    FORWARD_WHEN_NO_CONSUMERS((AttributeDefinition)CommonAttributes.FORWARD_WHEN_NO_CONSUMERS),
    GROUP_ADDRESS((AttributeDefinition)CommonAttributes.GROUP_ADDRESS),
    GROUP_PORT((AttributeDefinition)CommonAttributes.GROUP_PORT),
    GROUPING_HANDLER("grouping-handler"),
    HORNETQ_SERVER("hornetq-server"),
    ID_CACHE_SIZE((AttributeDefinition)CommonAttributes.ID_CACHE_SIZE),
    INITIAL_WAIT_TIMEOUT((AttributeDefinition)CommonAttributes.INITIAL_WAIT_TIMEOUT),
    IN_VM_ACCEPTOR("in-vm-acceptor"),
    IN_VM_CONNECTOR("in-vm-connector"),
    JMX_DOMAIN((AttributeDefinition)CommonAttributes.JMX_DOMAIN),
    JMX_MANAGEMENT_ENABLED((AttributeDefinition)CommonAttributes.JMX_MANAGEMENT_ENABLED),
    JOURNAL_BUFFER_SIZE((AttributeDefinition)CommonAttributes.JOURNAL_BUFFER_SIZE),
    JOURNAL_BUFFER_TIMEOUT((AttributeDefinition)CommonAttributes.JOURNAL_BUFFER_TIMEOUT),
    JOURNAL_COMPACT_MIN_FILES((AttributeDefinition)CommonAttributes.JOURNAL_COMPACT_MIN_FILES),
    JOURNAL_COMPACT_PERCENTAGE((AttributeDefinition)CommonAttributes.JOURNAL_COMPACT_PERCENTAGE),
    JOURNAL_DIRECTORY("journal-directory"),
    JOURNAL_FILE_SIZE((AttributeDefinition)CommonAttributes.JOURNAL_FILE_SIZE),
    JOURNAL_MAX_IO((AttributeDefinition)CommonAttributes.JOURNAL_MAX_IO),
    JOURNAL_MIN_FILES((AttributeDefinition)CommonAttributes.JOURNAL_MIN_FILES),
    JOURNAL_SYNC_NON_TRANSACTIONAL((AttributeDefinition)CommonAttributes.JOURNAL_SYNC_NON_TRANSACTIONAL),
    JOURNAL_SYNC_TRANSACTIONAL((AttributeDefinition)CommonAttributes.JOURNAL_SYNC_TRANSACTIONAL),
    JOURNAL_TYPE((AttributeDefinition)CommonAttributes.JOURNAL_TYPE),
    LARGE_MESSAGES_DIRECTORY("large-messages-directory"),
    LIVE_CONNECTOR_REF((AttributeDefinition)CommonAttributes.LIVE_CONNECTOR_REF),
    LOCAL_BIND_ADDRESS((AttributeDefinition)CommonAttributes.LOCAL_BIND_ADDRESS),
    LOCAL_BIND_PORT((AttributeDefinition)CommonAttributes.LOCAL_BIND_PORT),
    LOG_JOURNAL_WRITE_RATE((AttributeDefinition)CommonAttributes.LOG_JOURNAL_WRITE_RATE),
    MANAGEMENT_ADDRESS((AttributeDefinition)CommonAttributes.MANAGEMENT_ADDRESS),
    MANAGEMENT_NOTIFICATION_ADDRESS((AttributeDefinition)CommonAttributes.MANAGEMENT_NOTIFICATION_ADDRESS),
    MAX_HOPS((AttributeDefinition)CommonAttributes.MAX_HOPS),
    MEMORY_MEASURE_INTERVAL((AttributeDefinition)CommonAttributes.MEMORY_MEASURE_INTERVAL),
    MEMORY_WARNING_THRESHOLD((AttributeDefinition)CommonAttributes.MEMORY_WARNING_THRESHOLD),
    MESSAGE_COUNTER_ENABLED((AttributeDefinition)CommonAttributes.MESSAGE_COUNTER_ENABLED),
    MESSAGE_COUNTER_MAX_DAY_HISTORY((AttributeDefinition)CommonAttributes.MESSAGE_COUNTER_MAX_DAY_HISTORY),
    MESSAGE_COUNTER_SAMPLE_PERIOD((AttributeDefinition)CommonAttributes.MESSAGE_COUNTER_SAMPLE_PERIOD),
    MESSAGE_EXPIRY_SCAN_PERIOD((AttributeDefinition)CommonAttributes.MESSAGE_EXPIRY_SCAN_PERIOD),
    MESSAGE_EXPIRY_THREAD_PRIORITY((AttributeDefinition)CommonAttributes.MESSAGE_EXPIRY_THREAD_PRIORITY),
    NAME("name"),
    NETTY_ACCEPTOR("netty-acceptor"),
    NETTY_CONNECTOR("netty-connector"),
    PAGING_DIRECTORY("paging-directory"),
    PERF_BLAST_PAGES((AttributeDefinition)CommonAttributes.PERF_BLAST_PAGES),
    PERSIST_DELIVERY_COUNT_BEFORE_DELIVERY((AttributeDefinition)CommonAttributes.PERSIST_DELIVERY_COUNT_BEFORE_DELIVERY),
    PERSIST_ID_CACHE((AttributeDefinition)CommonAttributes.PERSIST_ID_CACHE),
    PERSISTENCE_ENABLED((AttributeDefinition)CommonAttributes.PERSISTENCE_ENABLED),
    QUEUE("queue"),
    REFRESH_TIMEOUT((AttributeDefinition)CommonAttributes.REFRESH_TIMEOUT),
    REMOTING_INTERCEPTORS((AttributeDefinition)CommonAttributes.REMOTING_INTERCEPTORS),
    ROUTING_NAME((AttributeDefinition)CommonAttributes.ROUTING_NAME),
    RUN_SYNC_SPEED_TEST((AttributeDefinition)CommonAttributes.RUN_SYNC_SPEED_TEST),
    SECURITY_ENABLED((AttributeDefinition)CommonAttributes.SECURITY_ENABLED),
    SECURITY_INVALIDATION_INTERVAL((AttributeDefinition)CommonAttributes.SECURITY_INVALIDATION_INTERVAL),
    SECURITY_SETTINGS("security-settings"),
    SERVER_DUMP_INTERVAL((AttributeDefinition)CommonAttributes.SERVER_DUMP_INTERVAL),
    SHARED_STORE((AttributeDefinition)CommonAttributes.SHARED_STORE),
    SUBSYSTEM("subsystem"),
    TRANSACTION_TIMEOUT((AttributeDefinition)CommonAttributes.TRANSACTION_TIMEOUT),
    TRANSACTION_TIMEOUT_SCAN_PERIOD((AttributeDefinition)CommonAttributes.TRANSACTION_TIMEOUT_SCAN_PERIOD),
    TRANSFORMER_CLASS_NAME((AttributeDefinition)CommonAttributes.TRANSFORMER_CLASS_NAME),
    WILD_CARD_ROUTING_ENABLED((AttributeDefinition)CommonAttributes.WILD_CARD_ROUTING_ENABLED),
    ACCEPTOR("acceptor"),
    CONNECTORS("connectors"),
    CONNECTOR("connector"),
    FACTORY_CLASS((AttributeDefinition)CommonAttributes.FACTORY_CLASS),
    FILTER((AttributeDefinition)CommonAttributes.FILTER),
    PARAM("param"),
    SECURITY_SETTING("security-setting"),
    PERMISSION_ELEMENT_NAME("permission"),
    ADDRESS_SETTING("address-setting"),
    DEAD_LETTER_ADDRESS_NODE_NAME((AttributeDefinition)CommonAttributes.DEAD_LETTER_ADDRESS),
    EXPIRY_ADDRESS_NODE_NAME((AttributeDefinition)CommonAttributes.EXPIRY_ADDRESS),
    REDELIVERY_DELAY_NODE_NAME((AttributeDefinition)CommonAttributes.REDELIVERY_DELAY),
    MAX_DELIVERY_ATTEMPTS((AttributeDefinition)CommonAttributes.MAX_DELIVERY_ATTEMPTS),
    MAX_SIZE_BYTES_NODE_NAME((AttributeDefinition)CommonAttributes.MAX_SIZE_BYTES_NODE_NAME),
    ADDRESS_FULL_MESSAGE_POLICY_NODE_NAME((AttributeDefinition)CommonAttributes.ADDRESS_FULL_MESSAGE_POLICY),
    PAGE_SIZE_BYTES_NODE_NAME((AttributeDefinition)CommonAttributes.PAGE_SIZE_BYTES_NODE_NAME),
    MESSAGE_COUNTER_HISTORY_DAY_LIMIT_NODE_NAME((AttributeDefinition)CommonAttributes.MESSAGE_COUNTER_HISTORY_DAY_LIMIT),
    LVQ_NODE_NAME((AttributeDefinition)CommonAttributes.LVQ),
    REDISTRIBUTION_DELAY_NODE_NAME((AttributeDefinition)CommonAttributes.REDISTRIBUTION_DELAY),
    SEND_TO_DLA_ON_NO_ROUTE((AttributeDefinition)CommonAttributes.SEND_TO_DLA_ON_NO_ROUTE),
    STATIC_CONNECTORS("static-connectors"),
    TIMEOUT((AttributeDefinition)CommonAttributes.TIMEOUT),
    TYPE((AttributeDefinition)CommonAttributes.TYPE),
    AUTO_GROUP((AttributeDefinition)CommonAttributes.AUTO_GROUP),
    BLOCK_ON_ACK((AttributeDefinition)CommonAttributes.BLOCK_ON_ACK),
    BLOCK_ON_DURABLE_SEND((AttributeDefinition)CommonAttributes.BLOCK_ON_DURABLE_SEND),
    BLOCK_ON_NON_DURABLE_SEND((AttributeDefinition)CommonAttributes.BLOCK_ON_NON_DURABLE_SEND),
    CACHE_LARGE_MESSAGE_CLIENT((AttributeDefinition)CommonAttributes.CACHE_LARGE_MESSAGE_CLIENT),
    CALL_TIMEOUT((AttributeDefinition)CommonAttributes.CALL_TIMEOUT),
    CLIENT_FAILURE_CHECK_PERIOD((AttributeDefinition)CommonAttributes.CLIENT_FAILURE_CHECK_PERIOD),
    CLIENT_ID((AttributeDefinition)CommonAttributes.CLIENT_ID),
    CONNECTION_FACTORY("connection-factory"),
    CONNECTION_FACTORIES("jms-connection-factories"),
    CONNECTION_TTL((AttributeDefinition)CommonAttributes.CONNECTION_TTL),
    CONFIRMATION_WINDOW_SIZE((AttributeDefinition)CommonAttributes.CONFIRMATION_WINDOW_SIZE),
    CONSUMER_MAX_RATE((AttributeDefinition)CommonAttributes.CONSUMER_MAX_RATE),
    CONSUMER_WINDOW_SIZE((AttributeDefinition)CommonAttributes.CONSUMER_WINDOW_SIZE),
    DISCOVERY_INITIAL_WAIT_TIMEOUT((AttributeDefinition)CommonAttributes.DISCOVERY_INITIAL_WAIT_TIMEOUT),
    DISCOVERY_GROUP_REF("discovery-group-ref"),
    DUPS_OK_BATCH_SIZE((AttributeDefinition)CommonAttributes.DUPS_OK_BATCH_SIZE),
    ENTRIES((AttributeDefinition)CommonAttributes.ENTRIES),
    ENTRY("entry"),
    FAILOVER_ON_INITIAL_CONNECTION((AttributeDefinition)CommonAttributes.FAILOVER_ON_INITIAL_CONNECTION),
    FAILOVER_ON_SERVER_SHUTDOWN((AttributeDefinition)CommonAttributes.FAILOVER_ON_SERVER_SHUTDOWN),
    GROUP_ID((AttributeDefinition)CommonAttributes.GROUP_ID),
    HA((AttributeDefinition)CommonAttributes.HA),
    JMS_DESTINATIONS("jms-destinations"),
    JMS_TOPIC("jms-topic"),
    JMS_QUEUE("jms-queue"),
    LOAD_BALANCING_CLASS_NAME((AttributeDefinition)CommonAttributes.LOAD_BALANCING_CLASS_NAME),
    MAX_RETRY_INTERVAL((AttributeDefinition)CommonAttributes.MAX_RETRY_INTERVAL),
    MIN_LARGE_MESSAGE_SIZE((AttributeDefinition)CommonAttributes.MIN_LARGE_MESSAGE_SIZE),
    PASSWORD((AttributeDefinition)CommonAttributes.PASSWORD),
    PRE_ACK((AttributeDefinition)CommonAttributes.PRE_ACK),
    PRODUCER_WINDOW_SIZE((AttributeDefinition)CommonAttributes.PRODUCER_WINDOW_SIZE),
    PRODUCER_MAX_RATE((AttributeDefinition)CommonAttributes.PRODUCER_MAX_RATE),
    QUEUE_NAME((AttributeDefinition)CommonAttributes.QUEUE_NAME),
    RECONNECT_ATTEMPTS(Element.getReconnectAttemptsDefinitions()),
    RETRY_INTERVAL(Element.getRetryIntervalDefinitions()),
    RETRY_INTERVAL_MULTIPLIER((AttributeDefinition)CommonAttributes.RETRY_INTERVAL_MULTIPLIER),
    SELECTOR((AttributeDefinition)CommonAttributes.SELECTOR),
    SCHEDULED_THREAD_POOL_MAX_SIZE(Element.getScheduledThreadPoolDefinitions()),
    THREAD_POOL_MAX_SIZE(Element.getThreadPoolDefinitions()),
    TRANSACTION_BATH_SIZE((AttributeDefinition)CommonAttributes.TRANSACTION_BATCH_SIZE),
    USER((AttributeDefinition)CommonAttributes.USER),
    USE_DUPLICATE_DETECTION(Element.getDuplicateDetectionDefinitions()),
    USE_GLOBAL_POOLS((AttributeDefinition)CommonAttributes.USE_GLOBAL_POOLS),
    POOLED_CONNECTION_FACTORY("pooled-connection-factory"),
    TRANSACTION("transaction"),
    MODE("mode"),
    INBOUND_CONFIG("inbound-config"),
    USE_JNDI((AttributeDefinition)CommonAttributes.USE_JNDI),
    JNDI_PARAMS((AttributeDefinition)CommonAttributes.JNDI_PARAMS),
    USE_LOCAL_TX((AttributeDefinition)CommonAttributes.USE_LOCAL_TX),
    SETUP_ATTEMPTS((AttributeDefinition)CommonAttributes.SETUP_ATTEMPTS),
    SETUP_INTERVAL((AttributeDefinition)CommonAttributes.SETUP_INTERVAL),
    SOCKET_BINDING(CommonAttributes.SOCKET_BINDING.getName());

    private final String name;
    private final AttributeDefinition definition;
    private final Map<String, AttributeDefinition> definitions;
    private static final Map<String, Element> MAP;

    private Element(String name) {
        this.name = name;
        this.definition = null;
        this.definitions = null;
    }

    private Element(AttributeDefinition definition) {
        this.name = definition.getXmlName();
        this.definition = definition;
        this.definitions = null;
    }

    private Element(List<AttributeDefinition> definitions) {
        this.definition = null;
        this.definitions = new HashMap<String, AttributeDefinition>();
        String ourName = null;
        for (AttributeDefinition def : definitions) {
            if (ourName == null) {
                ourName = def.getXmlName();
            } else if (!ourName.equals(def.getXmlName())) {
                throw MessagingMessages.MESSAGES.attributeDefinitionsMustMatch(def.getXmlName(), ourName);
            }
            if (this.definitions.put(def.getName(), def) == null) continue;
            throw MessagingMessages.MESSAGES.attributeDefinitionsNotUnique(def.getName());
        }
        this.name = ourName;
    }

    private Element(Map<String, AttributeDefinition> definitions) {
        this.definition = null;
        this.definitions = new HashMap<String, AttributeDefinition>();
        String ourName = null;
        for (Map.Entry<String, AttributeDefinition> def : definitions.entrySet()) {
            String xmlName = def.getValue().getXmlName();
            if (ourName == null) {
                ourName = xmlName;
            } else if (!ourName.equals(xmlName)) {
                throw MessagingMessages.MESSAGES.attributeDefinitionsMustMatch(xmlName, ourName);
            }
            this.definitions.put(def.getKey(), def.getValue());
        }
        this.name = ourName;
    }

    public String getLocalName() {
        return this.name;
    }

    public AttributeDefinition getDefinition() {
        return this.definition;
    }

    public AttributeDefinition getDefinition(String name) {
        return this.definitions.get(name);
    }

    public static Element forName(String localName) {
        Element element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    private static List<AttributeDefinition> getAttributeDefinitions(AttributeDefinition ... attributeDefinitions) {
        return Arrays.asList(attributeDefinitions);
    }

    private static Map<String, AttributeDefinition> getScheduledThreadPoolDefinitions() {
        HashMap<String, AttributeDefinition> result = new HashMap<String, AttributeDefinition>();
        result.put("server", (AttributeDefinition)CommonAttributes.SCHEDULED_THREAD_POOL_MAX_SIZE);
        result.put("connection", (AttributeDefinition)CommonAttributes.CONNECTION_SCHEDULED_THREAD_POOL_MAX_SIZE);
        return result;
    }

    private static Map<String, AttributeDefinition> getThreadPoolDefinitions() {
        HashMap<String, AttributeDefinition> result = new HashMap<String, AttributeDefinition>();
        result.put("server", (AttributeDefinition)CommonAttributes.THREAD_POOL_MAX_SIZE);
        result.put("connection", (AttributeDefinition)CommonAttributes.CONNECTION_THREAD_POOL_MAX_SIZE);
        return result;
    }

    private static Map<String, AttributeDefinition> getConnectorRefDefinitions() {
        HashMap<String, AttributeDefinition> result = new HashMap<String, AttributeDefinition>();
        result.put("simple", (AttributeDefinition)CommonAttributes.CONNECTOR_REF);
        result.put("broadcast-group", (AttributeDefinition)ConnectorRefsAttribute.BROADCAST_GROUP);
        result.put("bridge", (AttributeDefinition)ConnectorRefsAttribute.BRIDGE_CONNECTORS);
        result.put("cluster-connection", (AttributeDefinition)ConnectorRefsAttribute.CLUSTER_CONNECTION_CONNECTORS);
        return result;
    }

    private static Map<String, AttributeDefinition> getReconnectAttemptsDefinitions() {
        HashMap<String, AttributeDefinition> result = new HashMap<String, AttributeDefinition>();
        result.put("connection", (AttributeDefinition)CommonAttributes.CONNECTION_FACTORY_RECONNECT_ATTEMPTS);
        result.put("bridge", (AttributeDefinition)CommonAttributes.BRIDGE_RECONNECT_ATTEMPTS);
        return result;
    }

    private static Map<String, AttributeDefinition> getForwardingAddressDefinitions() {
        HashMap<String, AttributeDefinition> result = new HashMap<String, AttributeDefinition>();
        result.put("divert", (AttributeDefinition)CommonAttributes.DIVERT_FORWARDING_ADDRESS);
        result.put("bridge", (AttributeDefinition)CommonAttributes.BRIDGE_FORWARDING_ADDRESS);
        return result;
    }

    private static Map<String, AttributeDefinition> getDuplicateDetectionDefinitions() {
        HashMap<String, AttributeDefinition> result = new HashMap<String, AttributeDefinition>();
        result.put("cluster", (AttributeDefinition)CommonAttributes.CLUSTER_CONNECTION_USE_DUPLICATE_DETECTION);
        result.put("bridge", (AttributeDefinition)CommonAttributes.BRIDGE_USE_DUPLICATE_DETECTION);
        return result;
    }

    private static Map<String, AttributeDefinition> getRetryIntervalDefinitions() {
        HashMap<String, AttributeDefinition> result = new HashMap<String, AttributeDefinition>();
        result.put("cluster", (AttributeDefinition)CommonAttributes.CLUSTER_CONNECTION_RETRY_INTERVAL);
        result.put("default", (AttributeDefinition)CommonAttributes.RETRY_INTERVAL);
        return result;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>();
        for (Element element : Element.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

