/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.remoting.impl.invm.InVMAcceptorFactory;
import org.hornetq.core.remoting.impl.invm.InVMConnectorFactory;
import org.hornetq.core.remoting.impl.netty.NettyAcceptorFactory;
import org.hornetq.core.remoting.impl.netty.NettyConnectorFactory;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

class TransportConfigOperationHandlers {
    static AttributeDefinition[] GENERIC = new AttributeDefinition[]{CommonAttributes.FACTORY_CLASS, CommonAttributes.SOCKET_BINDING_OPTIONAL};
    static AttributeDefinition[] REMOTE = new AttributeDefinition[]{CommonAttributes.SOCKET_BINDING};
    static AttributeDefinition[] IN_VM = new AttributeDefinition[]{CommonAttributes.SERVER_ID};
    static final OperationStepHandler GENERIC_ADD = new BasicTransportConfigAdd(GENERIC);
    static final SelfRegisteringAttributeHandler GENERIC_ATTR = new AttributeWriteHandler(GENERIC);
    static final OperationStepHandler REMOTE_ADD = new BasicTransportConfigAdd(REMOTE);
    static final SelfRegisteringAttributeHandler REMOTE_ATTR = new AttributeWriteHandler(REMOTE);
    static final OperationStepHandler IN_VM_ADD = new BasicTransportConfigAdd(IN_VM);
    static final SelfRegisteringAttributeHandler IN_VM_ATTR = new AttributeWriteHandler(IN_VM);
    static final OperationStepHandler REMOVE = new OperationStepHandler(){

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            Resource resource = context.removeResource(PathAddress.EMPTY_ADDRESS);
            TransportConfigOperationHandlers.reloadRequiredStep(context);
            context.completeStep();
        }
    };
    static final OperationStepHandler PARAM_ADD = new OperationStepHandler(){

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
            CommonAttributes.VALUE.validateAndSet(operation, resource.getModel());
            TransportConfigOperationHandlers.reloadRequiredStep(context);
            context.completeStep();
        }
    };
    static final OperationStepHandler PARAM_ATTR = new OperationStepHandler(){

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
            CommonAttributes.VALUE.validateAndSet(operation, resource.getModel());
            TransportConfigOperationHandlers.reloadRequiredStep(context);
            context.completeStep();
        }
    };

    TransportConfigOperationHandlers() {
    }

    static ModelNode createAddOperation(ModelNode address, ModelNode node) {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        operation.get("address").set(address);
        if (node.hasDefined(CommonAttributes.SOCKET_BINDING.getName())) {
            operation.get(CommonAttributes.SOCKET_BINDING.getName()).set(node.get(CommonAttributes.SOCKET_BINDING.getName()));
        }
        if (node.hasDefined(CommonAttributes.SERVER_ID.getName())) {
            operation.get(CommonAttributes.SERVER_ID.getName()).set(node.get(CommonAttributes.SERVER_ID.getName()));
        }
        if (node.hasDefined("param")) {
            for (Property param : node.get("param").asPropertyList()) {
                operation.get(new String[]{"param", param.getName()}).set(param.getValue().get("value"));
            }
        }
        return operation;
    }

    static void reloadRequiredStep(OperationContext context) {
        if (context.getType() == OperationContext.Type.SERVER) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceName hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
                    ServiceController controller = context.getServiceRegistry(false).getService(hqServiceName);
                    if (controller != null) {
                        context.reloadRequired();
                    }
                    context.completeStep();
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    static void processAcceptors(Configuration configuration, ModelNode params, Set<String> bindings) {
        Map<String, Object> parameters;
        ModelNode config;
        String acceptorName;
        HashMap<String, TransportConfiguration> acceptors = new HashMap<String, TransportConfiguration>();
        if (params.hasDefined("acceptor")) {
            for (Property property : params.get("acceptor").asPropertyList()) {
                acceptorName = property.getName();
                config = property.getValue();
                parameters = TransportConfigOperationHandlers.getParameters(config);
                String clazz = config.get(CommonAttributes.FACTORY_CLASS.getName()).asString();
                acceptors.put(acceptorName, new TransportConfiguration(clazz, parameters, acceptorName));
            }
        }
        if (params.hasDefined("remote-acceptor")) {
            for (Property property : params.get("remote-acceptor").asPropertyList()) {
                acceptorName = property.getName();
                config = property.getValue();
                parameters = TransportConfigOperationHandlers.getParameters(config);
                String binding = config.get(CommonAttributes.SOCKET_BINDING.getName()).asString();
                parameters.put(CommonAttributes.SOCKET_BINDING.getName(), binding);
                bindings.add(binding);
                acceptors.put(acceptorName, new TransportConfiguration(NettyAcceptorFactory.class.getName(), parameters, acceptorName));
            }
        }
        if (params.hasDefined("in-vm-acceptor")) {
            for (Property property : params.get("in-vm-acceptor").asPropertyList()) {
                acceptorName = property.getName();
                config = property.getValue();
                parameters = TransportConfigOperationHandlers.getParameters(config);
                parameters.put(CommonAttributes.SERVER_ID.getName(), config.get(CommonAttributes.SERVER_ID.getName()).asInt());
                acceptors.put(acceptorName, new TransportConfiguration(InVMAcceptorFactory.class.getName(), parameters, acceptorName));
            }
        }
        configuration.setAcceptorConfigurations(new HashSet(acceptors.values()));
    }

    static Map<String, Object> getParameters(ModelNode config) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (config.get("param").isDefined()) {
            for (Property parameter : config.get("param").asPropertyList()) {
                parameters.put(parameter.getName(), parameter.getValue().get("value").asString());
            }
        }
        return parameters;
    }

    static void processConnectors(Configuration configuration, ModelNode params, Set<String> bindings) {
        Map<String, Object> parameters;
        ModelNode config;
        String connectorName;
        HashMap<String, TransportConfiguration> connectors = new HashMap<String, TransportConfiguration>();
        if (params.hasDefined("connector")) {
            for (Property property : params.get("connector").asPropertyList()) {
                connectorName = property.getName();
                config = property.getValue();
                parameters = TransportConfigOperationHandlers.getParameters(config);
                String clazz = config.get(CommonAttributes.FACTORY_CLASS.getName()).asString();
                connectors.put(connectorName, new TransportConfiguration(clazz, parameters, connectorName));
            }
        }
        if (params.hasDefined("remote-connector")) {
            for (Property property : params.get("remote-connector").asPropertyList()) {
                connectorName = property.getName();
                config = property.getValue();
                parameters = TransportConfigOperationHandlers.getParameters(config);
                String binding = config.get(CommonAttributes.SOCKET_BINDING.getName()).asString();
                parameters.put(CommonAttributes.SOCKET_BINDING.getName(), binding);
                bindings.add(binding);
                connectors.put(connectorName, new TransportConfiguration(NettyConnectorFactory.class.getName(), parameters, connectorName));
            }
        }
        if (params.hasDefined("in-vm-connector")) {
            for (Property property : params.get("in-vm-connector").asPropertyList()) {
                connectorName = property.getName();
                config = property.getValue();
                parameters = TransportConfigOperationHandlers.getParameters(config);
                parameters.put(CommonAttributes.SERVER_ID.getName(), config.get(CommonAttributes.SERVER_ID.getName()).asInt());
                connectors.put(connectorName, new TransportConfiguration(InVMConnectorFactory.class.getName(), parameters, connectorName));
            }
        }
        configuration.setConnectorConfigurations(connectors);
    }

    static class AttributeWriteHandler
    extends ReloadRequiredWriteAttributeHandler
    implements SelfRegisteringAttributeHandler {
        final AttributeDefinition[] attributes;

        private AttributeWriteHandler(AttributeDefinition[] attributes) {
            super(attributes);
            this.attributes = attributes;
        }

        @Override
        public void registerAttributes(ManagementResourceRegistration registry) {
            EnumSet<AttributeAccess.Flag> flags = EnumSet.of(AttributeAccess.Flag.RESTART_ALL_SERVICES);
            for (AttributeDefinition attr : this.attributes) {
                registry.registerReadWriteAttribute(attr.getName(), null, (OperationStepHandler)this, flags);
            }
        }
    }

    static interface SelfRegisteringAttributeHandler
    extends OperationStepHandler {
        public void registerAttributes(ManagementResourceRegistration var1);
    }

    private static class BasicTransportConfigAdd
    implements OperationStepHandler {
        private final AttributeDefinition[] attributes;

        BasicTransportConfigAdd(AttributeDefinition[] attributes) {
            this.attributes = attributes;
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
            ModelNode subModel = resource.getModel();
            for (AttributeDefinition attribute : this.attributes) {
                attribute.validateAndSet(operation, subModel);
            }
            this.process(subModel, operation);
            if (operation.hasDefined("param")) {
                for (Property property : operation.get("param").asPropertyList()) {
                    Resource param = context.createResource(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"param", (String)property.getName())}));
                    ModelNode value = property.getValue();
                    if (!value.isDefined()) {
                        throw new OperationFailedException(new ModelNode().set(MessagingMessages.MESSAGES.parameterNotDefined(property.getName())));
                    }
                    param.getModel().get("value").set(value);
                }
            }
            TransportConfigOperationHandlers.reloadRequiredStep(context);
            context.completeStep();
        }

        void process(ModelNode subModel, ModelNode operation) {
        }
    }
}

