/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.net;

import java.net.UnknownHostException;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.global.WriteAttributeHandlers;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.server.services.net.BindingAddHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

abstract class AbstractBindingWriteHandler
extends WriteAttributeHandlers.WriteAttributeOperationHandler {
    private static final ServiceName SOCKET_BINDING = SocketBinding.JBOSS_BINDING_NAME;
    private final ParameterValidator resolvedValueValidator;

    protected AbstractBindingWriteHandler() {
        this(null, null);
    }

    protected AbstractBindingWriteHandler(ParameterValidator valueValidator) {
        this(valueValidator, valueValidator);
    }

    protected AbstractBindingWriteHandler(ParameterValidator valueValidator, ParameterValidator resolvedValueValidator) {
        super(valueValidator);
        this.resolvedValueValidator = resolvedValueValidator;
    }

    protected boolean requiresRestart() {
        return false;
    }

    abstract void handleRuntimeChange(ModelNode var1, String var2, ModelNode var3, SocketBinding var4) throws OperationFailedException;

    abstract void handleRuntimeRollback(ModelNode var1, String var2, ModelNode var3, SocketBinding var4);

    protected void modelChanged(OperationContext context, ModelNode operation, final String attributeName, final ModelNode newValue, final ModelNode currentValue) throws OperationFailedException {
        boolean restartRequired = this.requiresRestart();
        boolean setReload = false;
        if (context.getType() == OperationContext.Type.SERVER) {
            if (restartRequired) {
                context.reloadRequired();
                setReload = true;
            } else {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        boolean bound;
                        ModelNode resolvedValue;
                        ModelNode modelNode = resolvedValue = newValue.isDefined() ? newValue.resolve() : newValue;
                        if (AbstractBindingWriteHandler.this.resolvedValueValidator != null) {
                            AbstractBindingWriteHandler.this.resolvedValueValidator.validateResolvedParameter("value", resolvedValue);
                        }
                        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
                        PathElement element = address.getLastElement();
                        String bindingName = element.getValue();
                        ModelNode bindingModel = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
                        ServiceController controller = context.getServiceRegistry(true).getRequiredService(SOCKET_BINDING.append(new String[]{bindingName}));
                        SocketBinding binding = controller.getState() == ServiceController.State.UP ? (SocketBinding)SocketBinding.class.cast(controller.getValue()) : null;
                        boolean bl = bound = binding != null && binding.isBound();
                        if (binding == null) {
                            AbstractBindingWriteHandler.this.handleBindingReinstall(context, bindingName, bindingModel);
                        } else if (bound) {
                            context.reloadRequired();
                        } else {
                            AbstractBindingWriteHandler.this.handleRuntimeChange(operation, attributeName, resolvedValue, binding);
                        }
                        if (context.completeStep() != OperationContext.ResultAction.KEEP) {
                            if (binding == null) {
                                AbstractBindingWriteHandler.this.revertBindingReinstall(context, bindingName, bindingModel, attributeName, currentValue);
                            } else if (bound) {
                                context.revertReloadRequired();
                            } else {
                                ModelNode resolvedPrevious = currentValue.isDefined() ? currentValue.resolve() : currentValue;
                                AbstractBindingWriteHandler.this.handleRuntimeRollback(operation, attributeName, resolvedPrevious, binding);
                            }
                        }
                    }
                }, OperationContext.Stage.RUNTIME);
            }
        }
        if (context.completeStep() != OperationContext.ResultAction.KEEP && setReload) {
            context.revertReloadRequired();
        }
    }

    private void handleBindingReinstall(OperationContext context, String bindingName, ModelNode bindingModel) throws OperationFailedException {
        context.removeService(SOCKET_BINDING.append(new String[]{bindingName}));
        try {
            BindingAddHandler.installBindingService(context, bindingModel, bindingName);
        }
        catch (UnknownHostException e) {
            throw new OperationFailedException(new ModelNode().set(e.getLocalizedMessage()));
        }
    }

    private void revertBindingReinstall(OperationContext context, String bindingName, ModelNode bindingModel, String attributeName, ModelNode previousValue) {
        context.removeService(SOCKET_BINDING.append(new String[]{bindingName}));
        ModelNode unresolvedConfig = bindingModel.clone();
        unresolvedConfig.get(attributeName).set(previousValue);
        try {
            BindingAddHandler.installBindingService(context, unresolvedConfig, bindingName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

