/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.pojo.descriptor;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.jboss.as.pojo.descriptor.AbstractConfigVisitorNode;
import org.jboss.as.pojo.descriptor.ConfigVisitor;
import org.jboss.as.pojo.descriptor.ConfigVisitorNode;
import org.jboss.as.pojo.descriptor.FactoryConfig;
import org.jboss.as.pojo.descriptor.ValueConfig;
import org.jboss.as.pojo.service.BeanInfo;
import org.jboss.as.pojo.service.Configurator;

public class ConstructorConfig
extends AbstractConfigVisitorNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String factoryClass;
    private String factoryMethod;
    private FactoryConfig factory;
    private ValueConfig[] parameters;

    @Override
    protected void addChildren(ConfigVisitor visitor, List<ConfigVisitorNode> nodes) {
        if (this.factory != null) {
            nodes.add(this.factory);
        }
        if (this.parameters != null) {
            nodes.addAll(Arrays.asList(this.parameters));
        }
    }

    @Override
    public Class<?> getType(ConfigVisitor visitor, ConfigVisitorNode previous) {
        if (this.factory != null) {
            throw new IllegalArgumentException("Too dynamic to determine injected type from factory!");
        }
        if (!(previous instanceof ValueConfig)) {
            throw new IllegalArgumentException("Previous node is not a value config!");
        }
        ValueConfig vc = (ValueConfig)previous;
        if (this.factoryClass != null) {
            if (this.factoryMethod == null) {
                throw new IllegalArgumentException("Null factory method!");
            }
            BeanInfo beanInfo = ConstructorConfig.getTempBeanInfo(visitor, this.factoryClass);
            Method m = beanInfo.findMethod(this.factoryMethod, Configurator.getTypes(this.parameters));
            return m.getParameterTypes()[vc.getIndex()];
        }
        BeanInfo beanInfo = visitor.getBeanInfo();
        if (beanInfo == null) {
            throw new IllegalArgumentException("No bean info!");
        }
        Constructor ctor = beanInfo.findConstructor(Configurator.getTypes(this.parameters));
        return ctor.getParameterTypes()[vc.getIndex()];
    }

    public String getFactoryClass() {
        return this.factoryClass;
    }

    public void setFactoryClass(String factoryClass) {
        this.factoryClass = factoryClass;
    }

    public String getFactoryMethod() {
        return this.factoryMethod;
    }

    public void setFactoryMethod(String factoryMethod) {
        this.factoryMethod = factoryMethod;
    }

    public FactoryConfig getFactory() {
        return this.factory;
    }

    public void setFactory(FactoryConfig factory) {
        this.factory = factory;
    }

    public ValueConfig[] getParameters() {
        return this.parameters;
    }

    public void setParameters(ValueConfig[] parameters) {
        this.parameters = parameters;
    }
}

