/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.AsyncConfigurationBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.ClusteringConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.HashConfigurationBuilder;
import org.infinispan.configuration.cache.L1ConfigurationBuilder;
import org.infinispan.configuration.cache.StateRetrievalConfigurationBuilder;
import org.infinispan.configuration.cache.SyncConfigurationBuilder;

public class ClusteringConfigurationBuilder
extends AbstractConfigurationChildBuilder<ClusteringConfiguration>
implements ClusteringConfigurationChildBuilder {
    private CacheMode cacheMode = CacheMode.LOCAL;
    private final AsyncConfigurationBuilder asyncConfigurationBuilder = new AsyncConfigurationBuilder(this);
    private final HashConfigurationBuilder hashConfigurationBuilder = new HashConfigurationBuilder(this);
    private final L1ConfigurationBuilder l1ConfigurationBuilder = new L1ConfigurationBuilder(this);
    private final StateRetrievalConfigurationBuilder stateRetrievalConfigurationBuilder = new StateRetrievalConfigurationBuilder(this);
    private final SyncConfigurationBuilder syncConfigurationBuilder = new SyncConfigurationBuilder(this);

    ClusteringConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public ClusteringConfigurationBuilder cacheMode(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
        return this;
    }

    @Override
    public AsyncConfigurationBuilder async() {
        if (!this.cacheMode.isSynchronous()) {
            throw new IllegalStateException("Cannot configure a async for an sync cache. Set the cache mode to async first.");
        }
        return this.asyncConfigurationBuilder;
    }

    @Override
    public HashConfigurationBuilder hash() {
        return this.hashConfigurationBuilder;
    }

    @Override
    public L1ConfigurationBuilder l1() {
        return this.l1ConfigurationBuilder;
    }

    @Override
    public StateRetrievalConfigurationBuilder stateRetrieval() {
        return this.stateRetrievalConfigurationBuilder;
    }

    @Override
    public SyncConfigurationBuilder sync() {
        if (!this.cacheMode.isSynchronous()) {
            throw new IllegalStateException("Cannot configure a sync for an async cache. Set the cache mode to sync first.");
        }
        return this.syncConfigurationBuilder;
    }

    @Override
    void validate() {
        this.asyncConfigurationBuilder.validate();
        this.hashConfigurationBuilder.validate();
        this.l1ConfigurationBuilder.validate();
        this.stateRetrievalConfigurationBuilder.validate();
        this.syncConfigurationBuilder.validate();
    }

    @Override
    ClusteringConfiguration create() {
        return new ClusteringConfiguration(this.cacheMode, this.asyncConfigurationBuilder.create(), this.hashConfigurationBuilder.create(), this.l1ConfigurationBuilder.create(), this.stateRetrievalConfigurationBuilder.create(), this.syncConfigurationBuilder.create());
    }
}

