/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.exts;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import net.jcip.annotations.Immutable;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.marshall.MarshallUtil;
import org.infinispan.util.Util;
import org.jboss.marshalling.util.IdentityIntMap;

@Immutable
public class SetExternalizer
extends AbstractExternalizer<Set> {
    private static final int HASHSET = 0;
    private static final int TREESET = 1;
    private final IdentityIntMap<Class<?>> numbers = new IdentityIntMap(2);

    public SetExternalizer() {
        this.numbers.put(HashSet.class, 0);
        this.numbers.put(TreeSet.class, 1);
    }

    public void writeObject(ObjectOutput output, Set set) throws IOException {
        int number = this.numbers.get(set.getClass(), -1);
        output.writeByte(number);
        MarshallUtil.marshallCollection((Collection)set, (ObjectOutput)output);
    }

    public Set readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        int magicNumber = input.readUnsignedByte();
        AbstractSet subject = null;
        switch (magicNumber) {
            case 0: {
                subject = new HashSet();
                break;
            }
            case 1: {
                subject = new TreeSet();
            }
        }
        int size = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
        for (int i = 0; i < size; ++i) {
            subject.add(input.readObject());
        }
        return subject;
    }

    public Integer getId() {
        return 3;
    }

    public Set<Class<? extends Set>> getTypeClasses() {
        return Util.asSet((Object[])new Class[]{HashSet.class, TreeSet.class});
    }
}

