/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.util.ReflectionUtil;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class CachedMethod {
    private final AnnotationInstance annotationInstance;
    private final boolean indexed;
    private final Method method;
    private final Class[] params;
    private final Annotation[][] paramAnnotations;
    private static final Map<ClassInfo, Class<?>> CLASS_CACHE = new ConcurrentHashMap();

    CachedMethod(Method reflectMethod) {
        this.method = reflectMethod;
        this.params = reflectMethod.getParameterTypes();
        this.paramAnnotations = reflectMethod.getParameterAnnotations();
        this.annotationInstance = null;
        this.indexed = false;
    }

    CachedMethod(AnnotationInstance annotationInstance, ClassLoader classLoader, MethodInfo methodInfo) throws ClassNotFoundException {
        this.indexed = true;
        this.annotationInstance = annotationInstance;
        ClassInfo classInfo = methodInfo.declaringClass();
        Class<?> c = CLASS_CACHE.get(classInfo);
        if (c == null) {
            c = classLoader.loadClass(classInfo.name().toString());
            CLASS_CACHE.put(classInfo, c);
        }
        this.params = new Class[methodInfo.args().length];
        int cntr = 0;
        for (Type t : methodInfo.args()) {
            this.params[cntr++] = classLoader.loadClass(t.toString());
        }
        this.method = ReflectionUtil.findMethod(c, methodInfo.name(), this.params);
        this.paramAnnotations = this.method.getParameterAnnotations();
    }

    public final Object invoke(Object target, Object ... params) throws InvocationTargetException, IllegalAccessException {
        return this.method.invoke(target, params);
    }

    public final Method getReflectMethod() {
        return this.method;
    }

    public final Class[] getParams() {
        return this.params;
    }

    public final Annotation[][] getParamAnnotations() {
        return this.paramAnnotations;
    }

    public int getAnnotationValueAsInt(String property) {
        if (this.indexed) {
            AnnotationValue value;
            AnnotationValue annotationValue = value = this.annotationInstance == null ? null : this.annotationInstance.value(property);
            if (value == null) {
                return 10;
            }
            return value.asInt();
        }
        throw new UnsupportedOperationException("Operation not supported for non-core component " + this.method);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CachedMethod that = (CachedMethod)o;
        return !(this.method != null ? !this.method.equals(that.method) : that.method != null);
    }

    public int hashCode() {
        return this.method != null ? this.method.hashCode() : 0;
    }
}

