/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.mail.extension;

import java.util.Locale;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.mail.extension.MailSessionAdd;
import org.jboss.as.mail.extension.MailSessionRemove;
import org.jboss.as.mail.extension.MailSubsystemAdd;
import org.jboss.as.mail.extension.MailSubsystemParser;
import org.jboss.as.mail.extension.MailSubsystemProviders;
import org.jboss.as.mail.extension.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class MailExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "mail";
    private final MailSubsystemParser parser = new MailSubsystemParser();

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(Namespace.CURRENT.getUriString(), (XMLElementReader)this.parser);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration registration = context.registerSubsystem(SUBSYSTEM_NAME);
        registration.registerXMLElementWriter((XMLElementWriter)this.parser);
        ManagementResourceRegistration subsystem = registration.registerSubsystemModel(MailSubsystemProviders.SUBSYSTEM);
        subsystem.registerOperationHandler("add", (OperationStepHandler)MailSubsystemAdd.INSTANCE, MailSubsystemProviders.SUBSYSTEM_ADD, false);
        subsystem.registerOperationHandler("describe", (OperationStepHandler)SubsystemDescribeHandler.INSTANCE, (DescriptionProvider)SubsystemDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        subsystem.registerOperationHandler("remove", (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE, MailSubsystemProviders.SUBSYSTEM_REMOVE, false);
        ManagementResourceRegistration mailSessions = subsystem.registerSubModel(PathElement.pathElement((String)"mail-session"), MailSubsystemProviders.MAIL_SESSION_DESC);
        mailSessions.registerOperationHandler("add", (OperationStepHandler)MailSessionAdd.INSTANCE, MailSubsystemProviders.ADD_MAIL_SESSION_DESC, false);
        mailSessions.registerOperationHandler("remove", (OperationStepHandler)MailSessionRemove.INSTANCE, (DescriptionProvider)MailSessionRemove.INSTANCE, false);
    }

    private static class SubsystemDescribeHandler
    implements OperationStepHandler,
    DescriptionProvider {
        static final SubsystemDescribeHandler INSTANCE = new SubsystemDescribeHandler();

        private SubsystemDescribeHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode result = context.getResult();
            PathAddress rootAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement()});
            ModelNode subModel = context.readModel(PathAddress.EMPTY_ADDRESS);
            ModelNode subsystemAdd = new ModelNode();
            subsystemAdd.get("operation").set("add");
            subsystemAdd.get("address").set(rootAddress.toModelNode());
            result.add(subsystemAdd);
            if (subModel.hasDefined("mail-session")) {
                for (Property session : subModel.get("mail-session").asPropertyList()) {
                    ModelNode address = rootAddress.toModelNode();
                    address.add("mail-session", session.getName());
                    ModelNode addOperation = Util.getEmptyOperation((String)"add", (ModelNode)address);
                    addOperation.get("jndi-name").set(session.getValue().get("jndi-name").asString());
                    addOperation.get("debug").set(session.getValue().get("debug").asString());
                    addOperation.get("smtp-server").set(session.getValue().get("smtp-server"));
                    addOperation.get("imap-server").set(session.getValue().get("imap-server"));
                    addOperation.get("pop3-server").set(session.getValue().get("pop3-server"));
                    result.add(addOperation);
                }
            }
            context.completeStep();
        }

        public ModelNode getModelDescription(Locale locale) {
            return CommonDescriptions.getSubsystemDescribeOperation((Locale)locale);
        }
    }
}

