/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.mail.extension;

import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.mail.extension.Attribute;
import org.jboss.as.mail.extension.Element;
import org.jboss.as.mail.extension.MailSessionConfig;
import org.jboss.as.mail.extension.MailSessionServer;
import org.jboss.as.mail.extension.Namespace;
import org.jboss.as.mail.extension.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

class MailSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    private static final Logger log = Logger.getLogger(MailSubsystemParser.class);

    MailSubsystemParser() {
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        log.tracef("model node: %s", (Object)context.getModelNode());
        ModelNode model = context.getModelNode();
        List sessions = model.get("mail-session").asPropertyList();
        for (Property mailSession : sessions) {
            String jndi = mailSession.getName();
            log.tracef("jndi: %s", (Object)jndi);
            ModelNode sessionData = mailSession.getValue();
            writer.writeStartElement(Element.MAIL_SESSION.getLocalName());
            writer.writeAttribute(Attribute.JNDI_NAME.getLocalName(), jndi);
            if (sessionData.hasDefined("debug")) {
                writer.writeAttribute(Attribute.DEBUG.getLocalName(), sessionData.get("debug").asString());
            }
            if (sessionData.hasDefined("smtp-server")) {
                this.writeServerModel(writer, sessionData, "smtp-server");
            }
            if (sessionData.hasDefined("pop3-server")) {
                this.writeServerModel(writer, sessionData, "pop3-server");
            }
            if (sessionData.hasDefined("imap-server")) {
                this.writeServerModel(writer, sessionData, "imap-server");
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeServerModel(XMLExtendedStreamWriter writer, ModelNode sessionData, String name) throws XMLStreamException {
        ModelNode server = sessionData.get(name);
        boolean credentials = server.hasDefined("credentials");
        if (credentials) {
            writer.writeStartElement(Element.forName(name).getLocalName());
        } else {
            writer.writeEmptyElement(Element.forName(name).getLocalName());
        }
        writer.writeAttribute(Attribute.OUTBOUND_SOCKET_BINDING_REF.getLocalName(), server.get("outbound-socket-binding-ref").asString());
        if (credentials) {
            writer.writeEmptyElement(Element.LOGIN.getLocalName());
            writer.writeAttribute(Attribute.USERNAME.getLocalName(), server.get("credentials").get("name").asString());
            writer.writeAttribute(Attribute.PASSWORD.getLocalName(), server.get("credentials").get("password").asString());
            writer.writeEndElement();
        }
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ModelNode address = new ModelNode();
        address.add("subsystem", "mail");
        address.protect();
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").set(address);
        list.add(subsystem);
        LinkedList<MailSessionConfig> sessionConfigList = new LinkedList<MailSessionConfig>();
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case MAIL_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case MAIL_SESSION: {
                            sessionConfigList.add(this.parseMailSession(reader, list));
                            continue block6;
                        }
                    }
                    reader.handleAny(list);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        for (MailSessionConfig c : sessionConfigList) {
            ModelNode dsAddress = address.clone();
            dsAddress.add("mail-session", c.getJndiName());
            dsAddress.protect();
            ModelNode operation = new ModelNode();
            operation.get("address").set(dsAddress);
            operation.get("operation").set("add");
            Util.fillFrom(operation, c);
            list.add(operation);
        }
        log.tracef("parsing done, config is: %s", sessionConfigList);
        log.tracef("list is: %s", list);
    }

    private MailSessionConfig parseMailSession(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        log.debug((Object)"parsing mail session");
        MailSessionConfig cfg = new MailSessionConfig();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attr = Attribute.forName(reader.getAttributeLocalName(i));
            String value = reader.getAttributeValue(i);
            if (attr == Attribute.JNDI_NAME) {
                String jndiName = value;
                log.tracef("jndi name: %s", (Object)jndiName);
                cfg.setJndiName(jndiName);
            }
            if (attr != Attribute.DEBUG) continue;
            boolean debug = Boolean.parseBoolean(value.trim());
            cfg.setDebug(debug);
        }
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case MAIL_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case SMTP_SERVER: {
                            cfg.setSmtpServer(this.parseServerConfig(reader));
                            continue block9;
                        }
                        case POP3_SERVER: {
                            cfg.setPop3Server(this.parseServerConfig(reader));
                            continue block9;
                        }
                        case IMAP_SERVER: {
                            cfg.setImapServer(this.parseServerConfig(reader));
                            continue block9;
                        }
                    }
                    reader.handleAny(list);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return cfg;
    }

    private MailSessionServer parseServerConfig(XMLExtendedStreamReader reader) throws XMLStreamException {
        String[] attributes = ParseUtils.requireAttributes((XMLExtendedStreamReader)reader, (String[])new String[]{Attribute.OUTBOUND_SOCKET_BINDING_REF.getLocalName()});
        String username = null;
        String password = null;
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case LOGIN: {
                    for (int i = 0; i < reader.getAttributeCount(); ++i) {
                        String att = reader.getAttributeLocalName(i);
                        if (att.equals(Attribute.USERNAME.getLocalName())) {
                            username = reader.getAttributeValue(i);
                            continue;
                        }
                        if (!att.equals(Attribute.PASSWORD.getLocalName())) continue;
                        password = reader.getAttributeValue(i);
                    }
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                }
            }
        }
        return new MailSessionServer(attributes[0], username, password);
    }
}

