/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.xml.bind.DatatypeConverter;
import org.jboss.ejb.client.ContextSelector;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.SecurityActions;
import org.jboss.ejb.client.remoting.IoFutureHelper;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.Remoting;
import org.jboss.remoting3.remote.RemoteConnectionProviderFactory;
import org.jboss.remoting3.spi.ConnectionProviderFactory;
import org.xnio.IoFuture;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;

class ConfigBasedEJBClientContextSelector
implements ContextSelector<EJBClientContext> {
    private static final Logger logger = Logger.getLogger(ConfigBasedEJBClientContextSelector.class);
    private static final long DEFAULT_CONNECTION_TIMEOUT_IN_MILLIS = 5000L;
    private static final String EJB_CLIENT_PROPS_FILE_SYS_PROPERTY = "jboss.ejb.client.properties.file.path";
    private static final String EJB_CLIENT_PROPS_SKIP_CLASSLOADER_SCAN_SYS_PROPERTY = "jboss.ejb.client.properties.skip.classloader.scan";
    private static final String EJB_CLIENT_PROPS_FILE_NAME = "jboss-ejb-client.properties";
    private static final String EJB_CLIENT_PROP_KEY_ENDPOINT_NAME = "endpoint.name";
    private static final String EJB_CLIENT_DEFAULT_ENDPOINT_NAME = "config-based-ejb-client-endpoint";
    private static final String USERNAME_KEY = "username";
    private static final String PASSWORD_KEY = "password";
    private static final String PASSWORD_BASE64_KEY = "password.base64";
    private static final String REALM_KEY = "realm";
    private static final String CALLBACK_HANDLER_KEY = "callback.handler.class";
    private static final String ENDPOINT_CREATION_OPTIONS_PREFIX = "endpoint.create.options.";
    private static final String REMOTE_CONNECTION_PROVIDER_CREATE_OPTIONS_PREFIX = "remote.connectionprovider.create.options.";
    private static final String REMOTE_CONNECTIONS_PROP_KEY = "remote.connections";
    private static final OptionMap DEFAULT_ENDPOINT_CREATION_OPTIONS = OptionMap.create((Option)Options.THREAD_DAEMON, (Object)true);
    private static final OptionMap DEFAULT_CONNECTION_CREATION_OPTIONS = OptionMap.EMPTY;
    private static final OptionMap DEFAULT_CONNECTION_PROVIDER_CREATION_OPTIONS = OptionMap.EMPTY;
    static final ConfigBasedEJBClientContextSelector INSTANCE = new ConfigBasedEJBClientContextSelector();
    private final EJBClientContext ejbClientContext = EJBClientContext.create();
    private Endpoint clientEndpoint;

    private ConfigBasedEJBClientContextSelector() {
        this.setupEJBReceivers();
    }

    @Override
    public EJBClientContext getCurrent() {
        return this.ejbClientContext;
    }

    private void setupEJBReceivers() {
        Properties ejbClientProperties = this.findEJBClientProperties();
        if (ejbClientProperties == null) {
            logger.debug((Object)("No jboss-ejb-client.properties found in classpath and no jboss.ejb.client.properties.file.path system property set. No EJB receivers will be associated with EJB client context " + this.ejbClientContext));
            return;
        }
        Collection<Connection> remotingConnections = this.createConnections(ejbClientProperties);
        for (Connection remotingConnection : remotingConnections) {
            this.ejbClientContext.registerConnection(remotingConnection);
        }
        logger.debug((Object)("Registered " + remotingConnections.size() + " remoting EJB receivers for EJB client context " + this.ejbClientContext));
    }

    private Properties findEJBClientProperties() {
        String ejbClientPropsFilePath = SecurityActions.getSystemProperty(EJB_CLIENT_PROPS_FILE_SYS_PROPERTY);
        if (ejbClientPropsFilePath != null) {
            FileInputStream fileStream;
            try {
                fileStream = new FileInputStream(ejbClientPropsFilePath);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Failed to find EJB client configuration file specified in jboss.ejb.client.properties.file.path system property", e);
            }
            Properties ejbClientProps = new Properties();
            try {
                ejbClientProps.load(fileStream);
                return ejbClientProps;
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading EJB client properties file " + ejbClientPropsFilePath, e);
            }
        }
        String skipClasspathScan = SecurityActions.getSystemProperty(EJB_CLIENT_PROPS_SKIP_CLASSLOADER_SCAN_SYS_PROPERTY);
        if (skipClasspathScan != null && Boolean.valueOf(skipClasspathScan.trim()).booleanValue()) {
            logger.debug((Object)"jboss.ejb.client.properties.skip.classloader.scan system property is set. Skipping classloader search for jboss-ejb-client.properties");
            return null;
        }
        ClassLoader classLoader = ConfigBasedEJBClientContextSelector.getClientClassLoader();
        logger.debug((Object)("Looking for jboss-ejb-client.properties using classloader " + classLoader));
        InputStream clientPropsInputStream = classLoader.getResourceAsStream(EJB_CLIENT_PROPS_FILE_NAME);
        if (clientPropsInputStream != null) {
            logger.debug((Object)("Found jboss-ejb-client.properties using classloader " + classLoader));
            Properties clientProps = new Properties();
            try {
                clientProps.load(clientPropsInputStream);
                return clientProps;
            }
            catch (IOException e) {
                throw new RuntimeException("Could not load jboss-ejb-client.properties", e);
            }
        }
        return null;
    }

    private Collection<Connection> createConnections(Properties ejbClientProperties) {
        String remoteConnectionNames = (String)ejbClientProperties.get(REMOTE_CONNECTIONS_PROP_KEY);
        if (remoteConnectionNames == null || remoteConnectionNames.trim().isEmpty()) {
            logger.debug((Object)"No remoting connections configured in EJB client configuration file");
            return Collections.emptySet();
        }
        StringTokenizer tokenizer = new StringTokenizer(remoteConnectionNames, ",");
        ArrayList<Connection> remotingConnections = new ArrayList<Connection>();
        while (tokenizer.hasMoreTokens()) {
            String connectionName = tokenizer.nextToken().trim();
            if (connectionName.isEmpty()) continue;
            Connection connection = null;
            try {
                connection = this.createConnection(connectionName, ejbClientProperties);
            }
            catch (Exception e) {
                logger.error((Object)("Could not create connection for connection named " + connectionName), (Throwable)e);
            }
            if (connection == null) {
                logger.info((Object)("Connection " + connectionName + " will not be available in EJB client context " + this.ejbClientContext));
                continue;
            }
            logger.debug((Object)("Connection " + connection + " successfully created for connection named " + connectionName));
            remotingConnections.add(connection);
        }
        return remotingConnections;
    }

    private void createEndpoint(Properties ejbClientProperties) throws IOException {
        String clientEndpointName = ejbClientProperties.getProperty(EJB_CLIENT_PROP_KEY_ENDPOINT_NAME, EJB_CLIENT_DEFAULT_ENDPOINT_NAME);
        OptionMap endPointCreationOptionsFromConfiguration = this.getOptionMapFromProperties(ejbClientProperties, ENDPOINT_CREATION_OPTIONS_PREFIX);
        OptionMap endPointCreationOptions = this.mergeWithDefaults(DEFAULT_ENDPOINT_CREATION_OPTIONS, endPointCreationOptionsFromConfiguration);
        this.clientEndpoint = Remoting.createEndpoint((String)clientEndpointName, (OptionMap)endPointCreationOptions);
        OptionMap remoteConnectionProivderOptionsFromConfiguration = this.getOptionMapFromProperties(ejbClientProperties, REMOTE_CONNECTION_PROVIDER_CREATE_OPTIONS_PREFIX);
        OptionMap remoteConnectionProivderOptions = this.mergeWithDefaults(DEFAULT_CONNECTION_PROVIDER_CREATION_OPTIONS, remoteConnectionProivderOptionsFromConfiguration);
        this.clientEndpoint.addConnectionProvider("remote", (ConnectionProviderFactory)new RemoteConnectionProviderFactory(), remoteConnectionProivderOptions);
    }

    private Connection createConnection(String connectionName, Properties ejbClientProperties) throws IOException, URISyntaxException {
        Integer port;
        Map<String, String> connectionSpecificProps = this.getConnectionSpecificProperties(connectionName, ejbClientProperties);
        if (connectionSpecificProps.isEmpty()) {
            return null;
        }
        String host = connectionSpecificProps.get("host");
        if (host == null || host.trim().isEmpty()) {
            logger.info((Object)("No host configured for connection named " + connectionName + ". Skipping connection creation"));
            return null;
        }
        String portStringVal = connectionSpecificProps.get("port");
        if (portStringVal == null || portStringVal.trim().isEmpty()) {
            logger.info((Object)("No port configured for connection named " + connectionName + ". Skipping connection creation"));
            return null;
        }
        try {
            port = Integer.parseInt(portStringVal.trim());
        }
        catch (NumberFormatException nfe) {
            logger.info((Object)("Incorrect port value: " + portStringVal + " specified for connection named " + connectionName + ". Skipping connection creation"));
            return null;
        }
        String connectOptionsPrefix = this.getConnectionSpecificConnectOptionsPrefix(connectionName);
        OptionMap connectOptionsFromConfiguration = this.getOptionMapFromProperties(ejbClientProperties, connectOptionsPrefix);
        OptionMap connectOptions = this.mergeWithDefaults(DEFAULT_CONNECTION_CREATION_OPTIONS, connectOptionsFromConfiguration);
        if (this.clientEndpoint == null) {
            this.createEndpoint(ejbClientProperties);
        }
        long connectionTimeout = 5000L;
        String connectionTimeoutValue = connectionSpecificProps.get("connect.timeout");
        if (connectionTimeoutValue != null && !connectionTimeoutValue.trim().isEmpty()) {
            try {
                connectionTimeout = Long.parseLong(connectionTimeoutValue.trim());
            }
            catch (NumberFormatException nfe) {
                logger.info((Object)("Incorrect timeout value " + connectionTimeoutValue + " specified for connection named " + connectionName + ". Falling back to default connection timeout value " + 5000L + " milli secondss"));
            }
        }
        CallbackHandler callbackHandler = this.createCallbackHandler(connectionName, connectionSpecificProps, ejbClientProperties);
        URI connectionURI = new URI("remote://" + host.trim() + ":" + port);
        IoFuture futureConnection = this.clientEndpoint.connect(connectionURI, connectOptions, callbackHandler);
        return (Connection)IoFutureHelper.get(futureConnection, connectionTimeout, TimeUnit.MILLISECONDS);
    }

    private CallbackHandler createCallbackHandler(String connectionName, Map<String, String> connectionSpecificProps, Properties ejbClientProperties) {
        String realm;
        String passwordBase64;
        String password;
        String userName;
        String callbackClass = connectionSpecificProps.get(CALLBACK_HANDLER_KEY);
        CallbackHandler handler = this.resolveCallbackHandler(connectionName, callbackClass, userName = connectionSpecificProps.get(USERNAME_KEY), password = connectionSpecificProps.get(PASSWORD_KEY), passwordBase64 = connectionSpecificProps.get(PASSWORD_BASE64_KEY), realm = connectionSpecificProps.get(REALM_KEY));
        if (handler != null) {
            return handler;
        }
        callbackClass = ejbClientProperties.getProperty(CALLBACK_HANDLER_KEY);
        handler = this.resolveCallbackHandler(connectionName, callbackClass, userName = ejbClientProperties.getProperty(USERNAME_KEY), password = ejbClientProperties.getProperty(PASSWORD_KEY), passwordBase64 = ejbClientProperties.getProperty(PASSWORD_BASE64_KEY), realm = ejbClientProperties.getProperty(REALM_KEY));
        if (handler != null) {
            return handler;
        }
        return new AnonymousCallbackHandler();
    }

    private CallbackHandler resolveCallbackHandler(String connectionName, String callbackClass, String userName, String password, String passwordBase64, String realm) {
        if (callbackClass != null && (userName != null || password != null)) {
            throw new RuntimeException("Cannot specify both a callback handler and a username/password for connection " + connectionName);
        }
        if (callbackClass != null) {
            ClassLoader classLoader = SecurityActions.getContextClassLoader();
            if (classLoader == null) {
                classLoader = ConfigBasedEJBClientContextSelector.class.getClassLoader();
            }
            try {
                Class<?> clazz = Class.forName(callbackClass, true, classLoader);
                return (CallbackHandler)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not load callback handler class " + callbackClass + " for connection " + connectionName, e);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not instantiate handler instance of type " + callbackClass + " for connection " + connectionName, e);
            }
        }
        if (userName != null) {
            String decodedPassword;
            if (password != null && passwordBase64 != null) {
                throw new RuntimeException("Cannot specify both a plain text and base64 encoded password for connection " + connectionName);
            }
            if (passwordBase64 != null) {
                try {
                    decodedPassword = DatatypeConverter.printBase64Binary((byte[])passwordBase64.getBytes());
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not decode base64 encoded password for connection " + connectionName, e);
                }
            } else {
                decodedPassword = password != null ? password : null;
            }
            return new AuthenticationCallbackHandler(userName, decodedPassword.toCharArray(), realm);
        }
        return null;
    }

    private Map<String, String> getConnectionSpecificProperties(String connectionName, Properties ejbClientProperties) {
        String connectionSpecificPropertyPrefix = this.getConnectionSpecificPrefix(connectionName);
        HashMap<String, String> connectionSpecificProps = new HashMap<String, String>();
        for (String fullPropName : ejbClientProperties.stringPropertyNames()) {
            if (!fullPropName.startsWith(connectionSpecificPropertyPrefix)) continue;
            String propName = fullPropName.substring(connectionSpecificPropertyPrefix.length());
            String propValue = ejbClientProperties.getProperty(fullPropName);
            connectionSpecificProps.put(propName, propValue);
        }
        return connectionSpecificProps;
    }

    private String getConnectionSpecificPrefix(String connectionName) {
        return "remote.connection." + connectionName + ".";
    }

    private String getConnectionSpecificConnectOptionsPrefix(String connectionName) {
        return "remote.connection." + connectionName + ".connect.options.";
    }

    private OptionMap getOptionMapFromProperties(Properties properties, String propertyPrefix) {
        ClassLoader classLoader = ConfigBasedEJBClientContextSelector.getClientClassLoader();
        OptionMap.Builder optionMapBuilder = OptionMap.builder().parseAll(properties, propertyPrefix, classLoader);
        OptionMap optionMap = optionMapBuilder.getMap();
        logger.debug((Object)(propertyPrefix + " has the following options " + optionMap));
        return optionMap;
    }

    private OptionMap mergeWithDefaults(OptionMap defaults, OptionMap overrides) {
        OptionMap.Builder combinedOptionsBuilder = OptionMap.builder().addAll(overrides);
        for (Option defaultOption : defaults) {
            if (combinedOptionsBuilder.getMap().contains(defaultOption)) continue;
            Object defaultValue = defaults.get(defaultOption);
            combinedOptionsBuilder.set(defaultOption, defaultValue);
        }
        OptionMap combinedOptions = combinedOptionsBuilder.getMap();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Options " + overrides + " have been merged with defaults " + defaults + " to form " + combinedOptions));
        }
        return combinedOptions;
    }

    private static ClassLoader getClientClassLoader() {
        ClassLoader tccl = SecurityActions.getContextClassLoader();
        if (tccl != null) {
            return tccl;
        }
        return ConfigBasedEJBClientContextSelector.class.getClassLoader();
    }

    private class AuthenticationCallbackHandler
    implements CallbackHandler {
        private final String realm;
        private final String username;
        private final char[] password;

        private AuthenticationCallbackHandler(String username, char[] password, String realm) {
            this.username = username;
            this.password = password;
            this.realm = realm;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback current : callbacks) {
                if (current instanceof RealmCallback) {
                    RealmCallback rcb = (RealmCallback)current;
                    if (this.realm == null) {
                        String defaultText = rcb.getDefaultText();
                        rcb.setText(defaultText);
                        continue;
                    }
                    rcb.setText(this.realm);
                    continue;
                }
                if (current instanceof NameCallback) {
                    NameCallback ncb = (NameCallback)current;
                    ncb.setName(this.username);
                    continue;
                }
                if (current instanceof PasswordCallback) {
                    PasswordCallback pcb = (PasswordCallback)current;
                    pcb.setPassword(this.password);
                    continue;
                }
                throw new UnsupportedCallbackException(current);
            }
        }
    }

    private class AnonymousCallbackHandler
    implements CallbackHandler {
        private AnonymousCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback current : callbacks) {
                if (!(current instanceof NameCallback)) {
                    throw new UnsupportedCallbackException(current);
                }
                NameCallback ncb = (NameCallback)current;
                ncb.setName("anonymous");
            }
        }
    }
}

