/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.messaging.HornetQServerRemove;
import org.jboss.dmr.ModelNode;

class MessagingSubsystemRemove
implements OperationStepHandler {
    static final MessagingSubsystemRemove INSTANCE = new MessagingSubsystemRemove();

    MessagingSubsystemRemove() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final Resource resource = context.removeResource(PathAddress.EMPTY_ADDRESS);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                Set serverNames = resource.getChildrenNames("hornetq-server");
                for (String serverName : serverNames) {
                    PathElement path = PathElement.pathElement((String)"hornetq-server", (String)serverName);
                    Resource server = resource.getChild(path);
                    HornetQServerRemove.removeHornetQServer(serverName, context, server);
                }
                if (context.completeStep() == OperationContext.ResultAction.ROLLBACK) {
                    // empty if block
                }
            }
        }, OperationContext.Stage.RUNTIME);
        context.completeStep();
    }
}

