/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import org.jboss.logging.BasicLogger;
import org.jboss.logging.Cause;
import org.jboss.logging.LogMessage;
import org.jboss.logging.Logger;
import org.jboss.logging.Message;
import org.jboss.logging.MessageLogger;

@MessageLogger(projectCode="JBAS")
public interface ServerLogger
extends BasicLogger {
    public static final ServerLogger ROOT_LOGGER = (ServerLogger)Logger.getMessageLogger(ServerLogger.class, (String)ServerLogger.class.getPackage().getName());
    public static final ServerLogger AS_ROOT_LOGGER = (ServerLogger)Logger.getMessageLogger(ServerLogger.class, (String)"org.jboss.as");
    public static final ServerLogger CONFIG_LOGGER = (ServerLogger)Logger.getMessageLogger(ServerLogger.class, (String)"org.jboss.as.config");
    public static final ServerLogger CONTROLLER_LOGGER = (ServerLogger)Logger.getMessageLogger(ServerLogger.class, (String)"org.jboss.as.controller");
    public static final ServerLogger DEPLOYMENT_LOGGER = (ServerLogger)Logger.getMessageLogger(ServerLogger.class, (String)"org.jboss.as.deployment");
    public static final ServerLogger DEPLOYMENT_MODULE_LOGGER = (ServerLogger)Logger.getMessageLogger(ServerLogger.class, (String)"org.jboss.as.deployment.module");

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="JBoss AS %s \"%s\" starting")
    public void serverStarting(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="JBoss AS %s \"%s\" stopped in %dms")
    public void serverStopped(String var1, String var2, int var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15850, value="%s in subdeployment ignored. jboss-deployment-structure.xml is only parsed for top level deployments.")
    public void jbossDeploymentStructureIgnored(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=15851, value="Could not read provided index: %s")
    public void cannotLoadAnnotationIndex(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15852, value="Could not index class %s at %s")
    public void cannotIndexClass(String var1, String var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15853, value="More than two unique criteria addresses were seen: %s")
    public void moreThanTwoUniqueCriteria(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15854, value="Checking two unique criteria addresses were seen: %s")
    public void checkingTwoUniqueCriteria(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15855, value="Two unique criteria addresses were seen: %s")
    public void twoUniqueCriteriaAddresses(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=15856, value="Undeploy of deployment \"%s\" was rolled back with failure message %s")
    public void undeploymentRolledBack(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=15857, value="Undeploy of deployment \"%s\" was rolled back with no failure message")
    public void undeploymentRolledBackWithNoMessage(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=18558, value="Undeployed \"%s\"")
    public void deploymentUndeployed(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=18559, value="Deployed \"%s\"")
    public void deploymentDeployed(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=15860, value="Redeploy of deployment \"%s\" was rolled back with failure message %s")
    public void redeployRolledBack(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=15861, value="Redeploy of deployment \"%s\" was rolled back with no failure message")
    public void redeployRolledBackWithNoMessage(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=18562, value="Redeployed \"%s\"")
    public void deploymentRedeployed(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=15863, value="Replacement of deployment \"%s\" by deployment \"%s\" was rolled back with failure message %s")
    public void replaceRolledBack(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=15864, value="Replacement of deployment \"%s\" by deployment \"%s\" was rolled back with no failure message")
    public void replaceRolledBackWithNoMessage(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=18565, value="Replaced deployment \"%s\" with deployment \"%s\"")
    public void deploymentReplaced(String var1, String var2);
}

