/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.ejb;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.as.weld.WeldContainer;
import org.jboss.as.weld.ejb.SecurityActions;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.weld.context.ejb.EjbLiteral;
import org.jboss.weld.context.ejb.EjbRequestContext;

public class EjbRequestScopeActivationInterceptor
implements Serializable,
Interceptor {
    private volatile EjbRequestContext requestContext;
    private final ClassLoader classLoader;
    private final InjectedValue<WeldContainer> weldContainer;

    public EjbRequestScopeActivationInterceptor(ClassLoader classLoader, InjectedValue<WeldContainer> weldContainer) {
        this.classLoader = classLoader;
        this.weldContainer = weldContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object processInvocation(InterceptorContext context) throws Exception {
        if (this.requestContext == null) {
            ClassLoader tccl = SecurityActions.getContextClassLoader();
            try {
                SecurityActions.setContextClassLoader(this.classLoader);
                BeanManager beanManager = ((WeldContainer)this.weldContainer.getValue()).getBeanManager();
                Bean bean = beanManager.resolve(beanManager.getBeans(EjbRequestContext.class, new Annotation[]{EjbLiteral.INSTANCE}));
                CreationalContext ctx = beanManager.createCreationalContext((Contextual)bean);
                this.requestContext = (EjbRequestContext)beanManager.getReference(bean, EjbRequestContext.class, ctx);
            }
            finally {
                SecurityActions.setContextClassLoader(tccl);
            }
        }
        try {
            this.requestContext.associate((Object)context.getInvocationContext());
            this.requestContext.activate();
            Object object = context.proceed();
            return object;
        }
        finally {
            this.requestContext.deactivate();
            this.requestContext.dissociate((Object)context.getInvocationContext());
        }
    }

    public static class Factory
    implements InterceptorFactory {
        private final InjectedValue<WeldContainer> weldContainer = new InjectedValue();
        private final Interceptor interceptor;

        public Factory(ClassLoader classLoader) {
            this.interceptor = new EjbRequestScopeActivationInterceptor(classLoader, this.weldContainer);
        }

        public Interceptor create(InterceptorFactoryContext context) {
            return this.interceptor;
        }

        public InjectedValue<WeldContainer> getWeldContainer() {
            return this.weldContainer;
        }
    }
}

