/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.security.SecureRandom;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

public class TopologyUUID
extends UUID {
    protected String site_id;
    protected String rack_id;
    protected String machine_id;

    public TopologyUUID() {
    }

    protected TopologyUUID(byte[] data, String site_id, String rack_id, String machine_id) {
        super(data);
        this.site_id = site_id;
        this.rack_id = rack_id;
        this.machine_id = machine_id;
    }

    public static TopologyUUID randomUUID(String site_id, String rack_id, String machine_id) {
        return new TopologyUUID(TopologyUUID.generateRandomBytes(), site_id, rack_id, machine_id);
    }

    public static TopologyUUID randomUUID(String logical_name, String site_id, String rack_id, String machine_id) {
        TopologyUUID retval = new TopologyUUID(TopologyUUID.generateRandomBytes(), site_id, rack_id, machine_id);
        UUID.add(retval, logical_name);
        return retval;
    }

    public String getSiteId() {
        return this.site_id;
    }

    public void setSiteId(String site_id) {
        this.site_id = site_id;
    }

    public String getRackId() {
        return this.rack_id;
    }

    public void setRackId(String rack_id) {
        this.rack_id = rack_id;
    }

    public String getMachineId() {
        return this.machine_id;
    }

    public void setMachineId(String machine_id) {
        this.machine_id = machine_id;
    }

    public boolean isSameSite(TopologyUUID addr) {
        return addr != null && (this.site_id != null && this.site_id.equals(addr.getSiteId()) || this.site_id == null && addr.getSiteId() == null);
    }

    public boolean isSameRack(TopologyUUID addr) {
        return addr != null && (this.rack_id != null && this.rack_id.equals(addr.getRackId()) || this.rack_id == null && addr.getRackId() == null);
    }

    public boolean isSameMachine(TopologyUUID addr) {
        return addr != null && (this.machine_id != null && this.machine_id.equals(addr.getMachineId()) || this.machine_id == null && addr.getMachineId() == null);
    }

    @Override
    public int size() {
        int retval = super.size() + 3;
        if (this.site_id != null) {
            retval += this.site_id.length() + 2;
        }
        if (this.rack_id != null) {
            retval += this.rack_id.length() + 2;
        }
        if (this.machine_id != null) {
            retval += this.machine_id.length() + 2;
        }
        return retval;
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        super.writeTo(out);
        Util.writeString(this.site_id, out);
        Util.writeString(this.rack_id, out);
        Util.writeString(this.machine_id, out);
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        super.readFrom(in);
        this.site_id = Util.readString(in);
        this.rack_id = Util.readString(in);
        this.machine_id = Util.readString(in);
    }

    @Override
    public String toString() {
        if (print_uuids) {
            return this.toStringLong() + (this.site_id == null ? "" : "(" + this.site_id + ")");
        }
        return super.toString() + (this.site_id == null ? "" : "(" + this.site_id + ")");
    }

    public String toStringDetailed() {
        if (print_uuids) {
            return this.toStringLong() + "(" + this.printDetails() + ")";
        }
        return super.toString() + "(" + this.printDetails() + ")";
    }

    protected static byte[] generateRandomBytes() {
        SecureRandom ng = numberGenerator;
        if (ng == null) {
            numberGenerator = ng = new SecureRandom();
        }
        byte[] randomBytes = new byte[16];
        ng.nextBytes(randomBytes);
        return randomBytes;
    }

    protected String printDetails() {
        StringBuilder sb = new StringBuilder();
        if (this.site_id != null) {
            sb.append(this.site_id);
        }
        sb.append(":");
        if (this.rack_id != null) {
            sb.append(this.rack_id);
        }
        sb.append(":");
        if (this.machine_id != null) {
            sb.append(this.machine_id);
        }
        return sb.toString();
    }
}

