/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxrs.deployment;

import org.jboss.as.jaxrs.deployment.JaxrsDeploymentMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.weld.WeldDeploymentMarker;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;

public class JaxrsDependencyProcessor
implements DeploymentUnitProcessor {
    public static ModuleIdentifier RESTEASY_ATOM = ModuleIdentifier.create((String)"org.jboss.resteasy.resteasy-atom-provider");
    public static ModuleIdentifier RESTEASY_CDI = ModuleIdentifier.create((String)"org.jboss.resteasy.resteasy-cdi");
    public static ModuleIdentifier RESTEASY_JAXRS = ModuleIdentifier.create((String)"org.jboss.resteasy.resteasy-jaxrs");
    public static ModuleIdentifier RESTEASY_JAXB = ModuleIdentifier.create((String)"org.jboss.resteasy.resteasy-jaxb-provider");
    public static ModuleIdentifier RESTEASY_JACKSON = ModuleIdentifier.create((String)"org.jboss.resteasy.resteasy-jackson-provider");
    public static ModuleIdentifier RESTEASY_JSAPI = ModuleIdentifier.create((String)"org.jboss.resteasy.resteasy-jsapi");
    public static ModuleIdentifier RESTEASY_MULTIPART = ModuleIdentifier.create((String)"org.jboss.resteasy.resteasy-multipart-provider");
    public static ModuleIdentifier JAXB_API = ModuleIdentifier.create((String)"javax.xml.bind.api");
    public static ModuleIdentifier JACKSON_CORE_ASL = ModuleIdentifier.create((String)"org.codehaus.jackson.jackson-core-asl");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        this.addDepdenency(moduleSpecification, moduleLoader, JAXB_API);
        if (!JaxrsDeploymentMarker.isJaxrsDeployment(deploymentUnit)) {
            return;
        }
        this.addDepdenency(moduleSpecification, moduleLoader, RESTEASY_ATOM);
        this.addDepdenency(moduleSpecification, moduleLoader, RESTEASY_JAXRS);
        this.addDepdenency(moduleSpecification, moduleLoader, RESTEASY_JAXB);
        this.addDepdenency(moduleSpecification, moduleLoader, RESTEASY_JACKSON);
        this.addDepdenency(moduleSpecification, moduleLoader, RESTEASY_JSAPI);
        this.addDepdenency(moduleSpecification, moduleLoader, RESTEASY_MULTIPART);
        this.addDepdenency(moduleSpecification, moduleLoader, JACKSON_CORE_ASL);
        if (WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)deploymentUnit)) {
            this.addDepdenency(moduleSpecification, moduleLoader, RESTEASY_CDI);
        }
    }

    private void addDepdenency(ModuleSpecification moduleSpecification, ModuleLoader moduleLoader, ModuleIdentifier moduleIdentifier) {
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, moduleIdentifier, false, false, true));
    }

    public void undeploy(DeploymentUnit context) {
    }
}

