/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb.security;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.jboss.logging.Logger;
import org.jboss.security.JSSESecurityDomain;

class Util {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.jacorb");

    Util() {
    }

    static SSLContext forDomain(JSSESecurityDomain securityDomain) throws IOException {
        SSLContext sslCtx = null;
        try {
            sslCtx = SSLContext.getInstance("TLS");
            KeyManager[] keyManagers = securityDomain.getKeyManagers();
            if (keyManagers == null) {
                throw new IOException("KeyManager[] is null for security domain: " + securityDomain.getSecurityDomain());
            }
            TrustManager[] trustManagers = securityDomain.getTrustManagers();
            sslCtx.init(keyManagers, trustManagers, null);
            return sslCtx;
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)"Failed to get SSLContext for TLS algorithm", (Throwable)e);
            throw new IOException("Failed to get SSLContext for TLS algorithm");
        }
        catch (KeyManagementException e) {
            log.error((Object)"Failed to init SSLContext", (Throwable)e);
            throw new IOException("Failed to init SSLContext");
        }
        catch (SecurityException e) {
            log.error((Object)"Failed to init SSLContext", (Throwable)e);
            throw new IOException("Failed to init SSLContext");
        }
    }
}

