/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.coordination;

import java.util.Map;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.domain.controller.DomainControllerMessages;
import org.jboss.as.domain.controller.operations.coordination.DomainOperationContext;
import org.jboss.dmr.ModelNode;

public class DomainFailureResultHandler
implements OperationStepHandler {
    private final DomainOperationContext domainOperationContext;

    public DomainFailureResultHandler(DomainOperationContext domainOperationContext) {
        this.domainOperationContext = domainOperationContext;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.getResult().set(new ModelNode());
        boolean isDomain = this.isDomainOperation(operation);
        if (!this.collectDomainFailure(context, isDomain)) {
            this.collectHostFailures(context, isDomain);
        }
        context.completeStep();
    }

    private boolean collectDomainFailure(OperationContext context, boolean isDomain) {
        ModelNode coordinator = this.domainOperationContext.getCoordinatorResult();
        ModelNode domainFailure = null;
        if (isDomain && coordinator != null && coordinator.has("failure-description")) {
            ModelNode modelNode = domainFailure = coordinator.hasDefined("failure-description") ? coordinator.get("failure-description") : new ModelNode().set(DomainControllerMessages.MESSAGES.unexplainedFailure());
        }
        if (domainFailure != null) {
            context.getFailureDescription().get("domain-failure-description").set(domainFailure);
            return true;
        }
        return false;
    }

    private boolean collectHostFailures(OperationContext context, boolean isDomain) {
        ModelNode hostFailureResults = null;
        for (Map.Entry<String, ModelNode> entry : this.domainOperationContext.getHostControllerResults().entrySet()) {
            ModelNode hostResult = entry.getValue();
            if (!hostResult.has("failure-description")) continue;
            if (hostFailureResults == null) {
                hostFailureResults = new ModelNode();
            }
            ModelNode desc = hostResult.hasDefined("failure-description") ? hostResult.get("failure-description") : new ModelNode().set(DomainControllerMessages.MESSAGES.unexplainedFailure());
            hostFailureResults.add(entry.getKey(), desc);
        }
        ModelNode coordinator = this.domainOperationContext.getCoordinatorResult();
        if (!isDomain && coordinator != null && coordinator.has("failure-description")) {
            if (hostFailureResults == null) {
                hostFailureResults = new ModelNode();
            }
            ModelNode desc = coordinator.hasDefined("failure-description") ? coordinator.get("failure-description") : new ModelNode().set(DomainControllerMessages.MESSAGES.unexplainedFailure());
            hostFailureResults.add(this.domainOperationContext.getLocalHostInfo().getLocalHostName(), desc);
        }
        if (hostFailureResults != null) {
            context.getFailureDescription().get("host-failure-descriptions").set(hostFailureResults);
            return true;
        }
        return false;
    }

    private boolean isDomainOperation(ModelNode operation) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        return address.size() == 0 || !address.getElement(0).getKey().equals("host");
    }
}

