/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.AbstractPluginService;
import org.jboss.osgi.framework.internal.BundleManager;
import org.jboss.osgi.framework.internal.BundleStorageState;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.vfs.VFSUtils;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Bundle;

final class BundleStoragePlugin
extends AbstractPluginService<BundleStoragePlugin> {
    final Logger log = Logger.getLogger(BundleStoragePlugin.class);
    private final InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();
    private boolean firstInit;
    private File storageArea;

    static void addService(ServiceTarget serviceTarget, boolean firstInit) {
        BundleStoragePlugin service = new BundleStoragePlugin(firstInit);
        ServiceBuilder builder = serviceTarget.addService(InternalServices.BUNDLE_STORAGE_PLUGIN, (Service)service);
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManager.class, service.injectedBundleManager);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
    }

    private BundleStoragePlugin(boolean firstInit) {
        this.firstInit = firstInit;
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
        BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
        String storageClean = (String)bundleManager.getProperty("org.osgi.framework.storage.clean");
        if (this.firstInit && "onFirstInit".equals(storageClean)) {
            this.cleanStorage();
        }
    }

    public BundleStoragePlugin getValue() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BundleStorageState createStorageState(long bundleId, String location, VirtualFile rootFile) throws IOException {
        int revision;
        if (location == null) {
            throw new IllegalArgumentException("Null location");
        }
        String bundlePath = this.getStorageDir(bundleId).getAbsolutePath();
        File bundleDir = new File(bundlePath);
        bundleDir.mkdirs();
        Properties props = BundleStorageState.loadProperties(bundleDir);
        String previousRev = props.getProperty("BundleRev");
        int n = revision = previousRev != null ? Integer.parseInt(previousRev) + 1 : 0;
        if (rootFile != null) {
            File revFile = new File(bundlePath + "/bundle-" + bundleId + "-rev-" + revision + ".jar");
            FileOutputStream output = new FileOutputStream(revFile);
            InputStream input = rootFile.openStream();
            try {
                VFSUtils.copyStream((InputStream)input, (OutputStream)output);
            }
            finally {
                input.close();
                output.close();
            }
            props.put("BundleFile", revFile.getName());
        }
        props.put("Location", location);
        props.put("BundleId", new Long(bundleId).toString());
        props.put("BundleRev", new Integer(revision).toString());
        props.put("LastModified", new Long(System.currentTimeMillis()).toString());
        return BundleStorageState.createBundleStorageState(bundleDir, rootFile, props);
    }

    List<BundleStorageState> getBundleStorageStates() throws IOException {
        ArrayList<BundleStorageState> states = new ArrayList<BundleStorageState>();
        File[] storageDirs = this.getStorageArea().listFiles();
        if (storageDirs != null) {
            for (File storageDir : storageDirs) {
                this.log.debugf("Creating storage state from: %s", (Object)storageDir);
                BundleStorageState storageState = BundleStorageState.createFromStorage(storageDir);
                states.add(storageState);
            }
        }
        return Collections.unmodifiableList(states);
    }

    File getDataFile(Bundle bundle, String filename) {
        File bundleDir = this.getStorageDir(bundle.getBundleId());
        File dataFile = new File(bundleDir.getAbsolutePath() + "/" + filename);
        dataFile.getParentFile().mkdirs();
        String filePath = dataFile.getAbsolutePath();
        try {
            filePath = dataFile.getCanonicalPath();
        }
        catch (IOException ex) {
            // empty catch block
        }
        return new File(filePath);
    }

    File getStorageDir(long bundleId) {
        File bundleDir = new File(this.getStorageArea() + "/bundle-" + bundleId);
        if (!bundleDir.exists()) {
            bundleDir.mkdirs();
        }
        String filePath = bundleDir.getAbsolutePath();
        try {
            filePath = bundleDir.getCanonicalPath();
        }
        catch (IOException ex) {
            // empty catch block
        }
        return new File(filePath);
    }

    private void cleanStorage() {
        File storage = this.getStorageArea();
        this.log.debugf("Deleting storage: %s", (Object)storage.getAbsolutePath());
        try {
            this.deleteRecursively(storage);
        }
        catch (IOException ex) {
            this.log.errorf((Throwable)ex, "Cannot delete storage area", new Object[0]);
        }
    }

    private File getStorageArea() {
        if (this.storageArea == null) {
            BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
            String dirName = (String)bundleManager.getProperty("org.osgi.framework.storage");
            if (dirName == null) {
                try {
                    File storageDir = new File("./osgi-store");
                    dirName = storageDir.getCanonicalPath();
                }
                catch (IOException ex) {
                    this.log.errorf((Throwable)ex, "Cannot create storage area", new Object[0]);
                    throw new IllegalStateException("Cannot create storage area");
                }
            }
            this.storageArea = new File(dirName).getAbsoluteFile();
        }
        return this.storageArea;
    }

    private void deleteRecursively(File file) throws IOException {
        if (file.isDirectory()) {
            for (File aux : file.listFiles()) {
                this.deleteRecursively(aux);
            }
        }
        file.delete();
    }
}

