/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security.operation;

import java.util.Calendar;
import java.util.Collection;
import java.util.ResourceBundle;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.extensions.security.element.SecurityHeader;
import org.jboss.ws.extensions.security.element.Timestamp;
import org.jboss.ws.extensions.security.exception.FailedCheckException;
import org.jboss.ws.extensions.security.exception.WSSecurityException;
import org.jboss.ws.extensions.security.operation.RequireOperation;
import org.w3c.dom.Document;

public class RequireTimestampOperation
implements RequireOperation {
    private static final ResourceBundle bundle = BundleUtils.getBundle(RequireTimestampOperation.class);
    private String maxAge;

    public RequireTimestampOperation(String maxAge) {
        this.maxAge = maxAge;
    }

    @Override
    public void process(Document message, SecurityHeader header, Collection<String> processedIds) throws WSSecurityException {
        Timestamp stamp = header.getTimestamp();
        if (stamp == null) {
            throw new FailedCheckException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"REQUIRED_TIMESTAMP_NOT_PRESENT", (Object[])new Object[0]));
        }
        if (this.maxAge == null) {
            return;
        }
        int max = Integer.parseInt(this.maxAge);
        Calendar expired = (Calendar)stamp.getCreated().clone();
        expired.add(13, max);
        if (!Calendar.getInstance().before(expired)) {
            throw new FailedCheckException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"TIMESTAMP_IS_TOO_OLD", (Object[])new Object[0]));
        }
    }
}

