/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.LoaderConfiguration;
import org.infinispan.configuration.cache.LoaderConfigurationBuilder;
import org.infinispan.configuration.cache.LoadersConfiguration;

public class LoadersConfigurationBuilder
extends AbstractConfigurationChildBuilder<LoadersConfiguration> {
    private boolean passivation = false;
    private boolean preload = false;
    private boolean shared = false;
    private List<LoaderConfigurationBuilder> cacheLoaders = new ArrayList<LoaderConfigurationBuilder>();

    protected LoadersConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public LoadersConfigurationBuilder passivation(boolean b) {
        this.passivation = b;
        return this;
    }

    boolean passivation() {
        return this.passivation;
    }

    public LoadersConfigurationBuilder preload(boolean b) {
        this.preload = b;
        return this;
    }

    public LoadersConfigurationBuilder shared(boolean b) {
        this.shared = b;
        return this;
    }

    boolean shared() {
        return this.shared;
    }

    public LoaderConfigurationBuilder addCacheLoader() {
        LoaderConfigurationBuilder builder = new LoaderConfigurationBuilder(this);
        this.cacheLoaders.add(builder);
        return builder;
    }

    List<LoaderConfigurationBuilder> cacheLoaders() {
        return this.cacheLoaders;
    }

    @Override
    void validate() {
        for (LoaderConfigurationBuilder b : this.cacheLoaders) {
            b.validate();
        }
    }

    @Override
    LoadersConfiguration create() {
        LinkedList<LoaderConfiguration> loaders = new LinkedList<LoaderConfiguration>();
        for (LoaderConfigurationBuilder loader : this.cacheLoaders) {
            loaders.add(loader.create());
        }
        return new LoadersConfiguration(this.passivation, this.preload, this.shared, loaders);
    }
}

