/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.ImmortalCacheValue;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.MortalCacheEntry;
import org.infinispan.container.entries.MortalCacheValue;
import org.infinispan.container.entries.TransientCacheEntry;
import org.infinispan.container.entries.TransientCacheValue;
import org.infinispan.container.entries.TransientMortalCacheEntry;
import org.infinispan.container.entries.TransientMortalCacheValue;
import org.infinispan.container.versioning.EntryVersion;

public class InternalEntryFactory {
    public static InternalCacheEntry create(Object key, Object value) {
        return InternalEntryFactory.create(key, value, null);
    }

    public static InternalCacheEntry create(Object key, Object value, EntryVersion version) {
        return new ImmortalCacheEntry(key, value, version);
    }

    public static InternalCacheEntry create(Object key, Object value, long lifespan) {
        return InternalEntryFactory.create(key, value, null, lifespan);
    }

    public static InternalCacheEntry create(Object key, Object value, EntryVersion version, long lifespan) {
        return lifespan > -1L ? new MortalCacheEntry(key, value, version, lifespan) : new ImmortalCacheEntry(key, value, version);
    }

    public static InternalCacheEntry create(Object key, Object value, long lifespan, long maxIdle) {
        return InternalEntryFactory.create(key, value, null, lifespan, maxIdle);
    }

    public static InternalCacheEntry create(Object key, Object value, EntryVersion version, long lifespan, long maxIdle) {
        if (lifespan < 0L && maxIdle < 0L) {
            return new ImmortalCacheEntry(key, value, version);
        }
        if (lifespan > -1L && maxIdle < 0L) {
            return new MortalCacheEntry(key, value, version, lifespan);
        }
        if (lifespan < 0L && maxIdle > -1L) {
            return new TransientCacheEntry(key, value, version, maxIdle);
        }
        return new TransientMortalCacheEntry(key, value, version, maxIdle, lifespan);
    }

    public static InternalCacheEntry create(Object key, Object value, long created, long lifespan, long lastUsed, long maxIdle) {
        return InternalEntryFactory.create(key, value, null, created, lifespan, lastUsed, maxIdle);
    }

    public static InternalCacheEntry create(Object key, Object value, EntryVersion version, long created, long lifespan, long lastUsed, long maxIdle) {
        if (lifespan < 0L && maxIdle < 0L) {
            return new ImmortalCacheEntry(key, value, version);
        }
        if (lifespan > -1L && maxIdle < 0L) {
            return new MortalCacheEntry(key, value, version, lifespan, created);
        }
        if (lifespan < 0L && maxIdle > -1L) {
            return new TransientCacheEntry(key, value, version, maxIdle, lastUsed);
        }
        return new TransientMortalCacheEntry(key, value, version, maxIdle, lifespan, lastUsed, created);
    }

    public static InternalCacheValue createValue(Object v) {
        return InternalEntryFactory.createValue(v, null);
    }

    public static InternalCacheValue createValue(Object v, EntryVersion version) {
        return new ImmortalCacheValue(v, version);
    }

    public static InternalCacheValue createValue(Object v, long created, long lifespan, long lastUsed, long maxIdle) {
        return InternalEntryFactory.createValue(v, null, created, lifespan, lastUsed, maxIdle);
    }

    public static InternalCacheValue createValue(Object v, EntryVersion version, long created, long lifespan, long lastUsed, long maxIdle) {
        if (lifespan < 0L && maxIdle < 0L) {
            return new ImmortalCacheValue(v, version);
        }
        if (lifespan > -1L && maxIdle < 0L) {
            return new MortalCacheValue(v, version, created, lifespan);
        }
        if (lifespan < 0L && maxIdle > -1L) {
            return new TransientCacheValue(v, version, maxIdle, lastUsed);
        }
        return new TransientMortalCacheValue(v, version, created, lifespan, maxIdle, lastUsed);
    }

    public InternalCacheEntry createNewEntry(Object key, Object value, EntryVersion version, long lifespan, long maxIdle) {
        if (lifespan < 0L && maxIdle < 0L) {
            return new ImmortalCacheEntry(key, value, version);
        }
        if (lifespan > -1L && maxIdle < 0L) {
            return new MortalCacheEntry(key, value, version, lifespan);
        }
        if (lifespan < 0L && maxIdle > -1L) {
            return new TransientCacheEntry(key, value, version, maxIdle);
        }
        return new TransientMortalCacheEntry(key, value, version, maxIdle, lifespan);
    }

    public InternalCacheEntry update(InternalCacheEntry ice, long lifespan, long maxIdle) {
        if (ice instanceof ImmortalCacheEntry) {
            if (lifespan < 0L) {
                if (maxIdle < 0L) {
                    return ice;
                }
                return new TransientCacheEntry(ice.getKey(), ice.getValue(), ice.getVersion(), maxIdle);
            }
            if (maxIdle < 0L) {
                return new MortalCacheEntry(ice.getKey(), ice.getValue(), ice.getVersion(), lifespan);
            }
            long ctm = System.currentTimeMillis();
            return new TransientMortalCacheEntry(ice.getKey(), ice.getValue(), ice.getVersion(), maxIdle, lifespan, ctm, ctm);
        }
        if (ice instanceof MortalCacheEntry) {
            if (lifespan < 0L) {
                if (maxIdle < 0L) {
                    return new ImmortalCacheEntry(ice.getKey(), ice.getValue(), ice.getVersion());
                }
                return new TransientCacheEntry(ice.getKey(), ice.getValue(), ice.getVersion(), maxIdle);
            }
            if (maxIdle < 0L) {
                ice.setLifespan(lifespan);
                return ice;
            }
            long ctm = System.currentTimeMillis();
            return new TransientMortalCacheEntry(ice.getKey(), ice.getValue(), ice.getVersion(), maxIdle, lifespan, ctm, ctm);
        }
        if (ice instanceof TransientCacheEntry) {
            if (lifespan < 0L) {
                if (maxIdle < 0L) {
                    return new ImmortalCacheEntry(ice.getKey(), ice.getValue(), ice.getVersion());
                }
                ice.setMaxIdle(maxIdle);
                return ice;
            }
            if (maxIdle < 0L) {
                return new MortalCacheEntry(ice.getKey(), ice.getValue(), ice.getVersion(), lifespan);
            }
            long ctm = System.currentTimeMillis();
            return new TransientMortalCacheEntry(ice.getKey(), ice.getValue(), ice.getVersion(), maxIdle, lifespan, ctm, ctm);
        }
        if (ice instanceof TransientMortalCacheEntry) {
            if (lifespan < 0L) {
                if (maxIdle < 0L) {
                    return new ImmortalCacheEntry(ice.getKey(), ice.getValue(), ice.getVersion());
                }
                return new TransientCacheEntry(ice.getKey(), ice.getValue(), ice.getVersion(), maxIdle);
            }
            if (maxIdle < 0L) {
                return new MortalCacheEntry(ice.getKey(), ice.getValue(), ice.getVersion(), lifespan);
            }
            ice.setLifespan(lifespan);
            ice.setMaxIdle(maxIdle);
            return ice;
        }
        return ice;
    }
}

