/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import java.util.List;
import org.infinispan.CacheException;
import org.infinispan.config.Configuration;
import org.infinispan.config.ConfigurationException;
import org.infinispan.config.CustomInterceptorConfig;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.interceptors.ActivationInterceptor;
import org.infinispan.interceptors.BatchingInterceptor;
import org.infinispan.interceptors.CacheLoaderInterceptor;
import org.infinispan.interceptors.CacheMgmtInterceptor;
import org.infinispan.interceptors.CacheStoreInterceptor;
import org.infinispan.interceptors.CallInterceptor;
import org.infinispan.interceptors.DeadlockDetectingInterceptor;
import org.infinispan.interceptors.DistCacheStoreInterceptor;
import org.infinispan.interceptors.DistTxInterceptor;
import org.infinispan.interceptors.DistributionInterceptor;
import org.infinispan.interceptors.EntryWrappingInterceptor;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.interceptors.InvalidationInterceptor;
import org.infinispan.interceptors.InvocationContextInterceptor;
import org.infinispan.interceptors.IsMarshallableInterceptor;
import org.infinispan.interceptors.MarshalledValueInterceptor;
import org.infinispan.interceptors.NotificationInterceptor;
import org.infinispan.interceptors.PassivationInterceptor;
import org.infinispan.interceptors.ReplicationInterceptor;
import org.infinispan.interceptors.StateTransferLockInterceptor;
import org.infinispan.interceptors.TxInterceptor;
import org.infinispan.interceptors.VersionedDistributionInterceptor;
import org.infinispan.interceptors.VersionedEntryWrappingInterceptor;
import org.infinispan.interceptors.VersionedReplicationInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.interceptors.locking.NonTransactionalLockingInterceptor;
import org.infinispan.interceptors.locking.OptimisticLockingInterceptor;
import org.infinispan.interceptors.locking.PessimisticLockingInterceptor;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheStoreConfig;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@DefaultFactoryFor(classes={InterceptorChain.class})
public class InterceptorChainFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    private static final Log log = LogFactory.getLog(InterceptorChainFactory.class);

    public CommandInterceptor createInterceptor(Class<? extends CommandInterceptor> clazz) {
        CommandInterceptor chainedInterceptor = this.componentRegistry.getComponent(clazz);
        if (chainedInterceptor == null) {
            chainedInterceptor = Util.getInstance(clazz);
            this.register(clazz, chainedInterceptor);
        } else {
            chainedInterceptor.setNext(null);
        }
        return chainedInterceptor;
    }

    private void register(Class<? extends CommandInterceptor> clazz, CommandInterceptor chainedInterceptor) {
        try {
            this.componentRegistry.registerComponent((Object)chainedInterceptor, clazz);
        }
        catch (RuntimeException e) {
            log.warn("Problems creating interceptor " + clazz);
            throw e;
        }
    }

    private boolean isUsingMarshalledValues(Configuration c) {
        return c.isStoreAsBinary() && (c.isStoreKeysAsBinary() || c.isStoreValuesAsBinary());
    }

    public InterceptorChain buildInterceptorChain() {
        boolean needsVersionAwareComponents = this.configuration.isTransactionalCache() && this.configuration.isWriteSkewCheck() && this.configuration.getTransactionLockingMode() == LockingMode.OPTIMISTIC && this.configuration.isEnableVersioning();
        boolean invocationBatching = this.configuration.isInvocationBatchingEnabled();
        CommandInterceptor first = invocationBatching ? this.createInterceptor(BatchingInterceptor.class) : this.createInterceptor(InvocationContextInterceptor.class);
        InterceptorChain interceptorChain = new InterceptorChain(first);
        this.componentRegistry.registerComponent((Object)interceptorChain, InterceptorChain.class);
        if (this.isUsingMarshalledValues(this.configuration) || this.configuration.isUseAsyncMarshalling() || this.configuration.isUseReplQueue() || this.hasAsyncStore()) {
            interceptorChain.appendInterceptor(this.createInterceptor(IsMarshallableInterceptor.class));
        }
        if (invocationBatching) {
            interceptorChain.appendInterceptor(this.createInterceptor(InvocationContextInterceptor.class));
        }
        if (this.configuration.isExposeJmxStatistics()) {
            interceptorChain.appendInterceptor(this.createInterceptor(CacheMgmtInterceptor.class));
        }
        if (this.configuration.getCacheMode().isDistributed() || this.configuration.getCacheMode().isReplicated()) {
            interceptorChain.appendInterceptor(this.createInterceptor(StateTransferLockInterceptor.class));
        }
        if (this.configuration.isTransactionalCache()) {
            if (this.configuration.getCacheMode().isDistributed()) {
                interceptorChain.appendInterceptor(this.createInterceptor(DistTxInterceptor.class));
            } else {
                interceptorChain.appendInterceptor(this.createInterceptor(TxInterceptor.class));
            }
        }
        if (this.isUsingMarshalledValues(this.configuration)) {
            interceptorChain.appendInterceptor(this.createInterceptor(MarshalledValueInterceptor.class));
        }
        interceptorChain.appendInterceptor(this.createInterceptor(NotificationInterceptor.class));
        if (this.configuration.isUseEagerLocking()) {
            this.configuration.fluent().transaction().lockingMode(LockingMode.PESSIMISTIC);
        }
        if (this.configuration.isTransactionalCache()) {
            if (this.configuration.getTransactionLockingMode() == LockingMode.PESSIMISTIC) {
                interceptorChain.appendInterceptor(this.createInterceptor(PessimisticLockingInterceptor.class));
            } else {
                interceptorChain.appendInterceptor(this.createInterceptor(OptimisticLockingInterceptor.class));
            }
        } else {
            interceptorChain.appendInterceptor(this.createInterceptor(NonTransactionalLockingInterceptor.class));
        }
        if (needsVersionAwareComponents && this.configuration.getCacheMode().isClustered()) {
            interceptorChain.appendInterceptor(this.createInterceptor(VersionedEntryWrappingInterceptor.class));
        } else {
            interceptorChain.appendInterceptor(this.createInterceptor(EntryWrappingInterceptor.class));
        }
        if (this.configuration.isUsingCacheLoaders()) {
            if (this.configuration.getCacheLoaderManagerConfig().isPassivation().booleanValue()) {
                interceptorChain.appendInterceptor(this.createInterceptor(ActivationInterceptor.class));
                interceptorChain.appendInterceptor(this.createInterceptor(PassivationInterceptor.class));
            } else {
                interceptorChain.appendInterceptor(this.createInterceptor(CacheLoaderInterceptor.class));
                switch (this.configuration.getCacheMode()) {
                    case DIST_SYNC: 
                    case DIST_ASYNC: {
                        interceptorChain.appendInterceptor(this.createInterceptor(DistCacheStoreInterceptor.class));
                        break;
                    }
                    default: {
                        interceptorChain.appendInterceptor(this.createInterceptor(CacheStoreInterceptor.class));
                    }
                }
            }
        }
        if (this.configuration.isEnableDeadlockDetection()) {
            interceptorChain.appendInterceptor(this.createInterceptor(DeadlockDetectingInterceptor.class));
        }
        switch (this.configuration.getCacheMode()) {
            case REPL_SYNC: {
                if (needsVersionAwareComponents) {
                    interceptorChain.appendInterceptor(this.createInterceptor(VersionedReplicationInterceptor.class));
                    break;
                }
            }
            case REPL_ASYNC: {
                interceptorChain.appendInterceptor(this.createInterceptor(ReplicationInterceptor.class));
                break;
            }
            case INVALIDATION_SYNC: 
            case INVALIDATION_ASYNC: {
                interceptorChain.appendInterceptor(this.createInterceptor(InvalidationInterceptor.class));
                break;
            }
            case DIST_SYNC: {
                if (needsVersionAwareComponents) {
                    interceptorChain.appendInterceptor(this.createInterceptor(VersionedDistributionInterceptor.class));
                    break;
                }
            }
            case DIST_ASYNC: {
                interceptorChain.appendInterceptor(this.createInterceptor(DistributionInterceptor.class));
                break;
            }
        }
        CommandInterceptor callInterceptor = this.createInterceptor(CallInterceptor.class);
        interceptorChain.appendInterceptor(callInterceptor);
        if (log.isTraceEnabled()) {
            log.trace("Finished building default interceptor chain.");
        }
        this.buildCustomInterceptors(interceptorChain, this.configuration.getCustomInterceptors());
        return interceptorChain;
    }

    private Class<? extends CommandInterceptor> getCustomInterceptorType(CustomInterceptorConfig cfg) {
        if (cfg.getInterceptor() != null) {
            return cfg.getInterceptor().getClass();
        }
        return Util.loadClass(cfg.getClassName(), this.configuration.getClassLoader());
    }

    private CommandInterceptor getOrCreateCustomInterceptor(CustomInterceptorConfig cfg) {
        CommandInterceptor result = cfg.getInterceptor();
        if (result == null) {
            result = (CommandInterceptor)Util.getInstance(cfg.getClassName(), this.configuration.getClassLoader());
        }
        this.register(result.getClass(), result);
        return result;
    }

    private void buildCustomInterceptors(InterceptorChain interceptorChain, List<CustomInterceptorConfig> customInterceptors) {
        for (CustomInterceptorConfig config : customInterceptors) {
            List<CommandInterceptor> withClassName;
            if (interceptorChain.containsInterceptorType(this.getCustomInterceptorType(config))) continue;
            if (config.isFirst()) {
                interceptorChain.addInterceptor(this.getOrCreateCustomInterceptor(config), 0);
                continue;
            }
            if (config.isLast()) {
                interceptorChain.appendInterceptor(this.getOrCreateCustomInterceptor(config));
                continue;
            }
            if (config.getIndex() >= 0) {
                interceptorChain.addInterceptor(this.getOrCreateCustomInterceptor(config), config.getIndex());
                continue;
            }
            if (config.getAfter() != null) {
                withClassName = interceptorChain.getInterceptorsWithClassName(config.getAfter());
                if (withClassName.isEmpty()) {
                    throw new ConfigurationException("Cannot add after class: " + config.getAfter() + " as no such interceptor exists in the default chain");
                }
                interceptorChain.addInterceptorAfter(this.getOrCreateCustomInterceptor(config), withClassName.get(0).getClass());
                continue;
            }
            if (config.getBefore() == null) continue;
            withClassName = interceptorChain.getInterceptorsWithClassName(config.getBefore());
            if (withClassName.isEmpty()) {
                throw new ConfigurationException("Cannot add before class: " + config.getAfter() + " as no such interceptor exists in the default chain");
            }
            interceptorChain.addInterceptorBefore(this.getOrCreateCustomInterceptor(config), withClassName.get(0).getClass());
        }
    }

    private boolean hasAsyncStore() {
        List<CacheLoaderConfig> loaderConfigs = this.configuration.getCacheLoaderManagerConfig().getCacheLoaderConfigs();
        for (CacheLoaderConfig loaderConfig : loaderConfigs) {
            CacheStoreConfig storeConfig;
            if (!(loaderConfig instanceof CacheStoreConfig) || !(storeConfig = (CacheStoreConfig)loaderConfig).getAsyncStoreConfig().isEnabled().booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> T construct(Class<T> componentType) {
        try {
            return componentType.cast(this.buildInterceptorChain());
        }
        catch (CacheException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to build interceptor chain", e);
        }
    }

    public static InterceptorChainFactory getInstance(ComponentRegistry componentRegistry, Configuration configuration) {
        InterceptorChainFactory icf = new InterceptorChainFactory();
        icf.componentRegistry = componentRegistry;
        icf.configuration = configuration;
        return icf;
    }
}

