/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.CacheException;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.config.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class StateTransferLockImpl
implements StateTransferLock {
    private static final Log log = LogFactory.getLog(StateTransferLockImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final int NO_BLOCKING_CACHE_VIEW = -1;
    private AtomicInteger runningWritesCount = new AtomicInteger(0);
    private volatile boolean writesShouldBlock;
    private volatile boolean writesBlocked;
    private ThreadLocal<Boolean> traceThreadWrites = new ThreadLocal();
    private int blockingCacheViewId = -1;
    private final Object lock = new Object();
    private boolean stateTransferEnabled;
    private boolean pessimisticLocking;
    private long lockTimeout;

    @Inject
    public void injectDependencies(Configuration config) {
        this.stateTransferEnabled = config.getCacheMode().isDistributed() && config.isRehashEnabled() || config.getCacheMode().isReplicated() && config.isStateTransferEnabled();
        this.pessimisticLocking = config.getTransactionLockingMode() == LockingMode.PESSIMISTIC;
        this.lockTimeout = config.getRehashWaitTime();
    }

    @Override
    public void releaseForCommand(InvocationContext ctx, WriteCommand command) {
        if (this.shouldAcquireLock(ctx, command)) {
            this.releaseLockForWrite();
        }
    }

    @Override
    public void releaseForCommand(TxInvocationContext ctx, PrepareCommand command) {
        if (this.shouldAcquireLock(ctx, command)) {
            this.releaseLockForWrite();
        }
    }

    @Override
    public void releaseForCommand(TxInvocationContext ctx, CommitCommand command) {
        if (this.shouldAcquireLock(ctx, command)) {
            this.releaseLockForWrite();
        }
    }

    @Override
    public void releaseForCommand(TxInvocationContext ctx, RollbackCommand command) {
    }

    @Override
    public void releaseForCommand(TxInvocationContext ctx, LockControlCommand command) {
        if (this.shouldAcquireLock(ctx, command)) {
            this.releaseLockForWrite();
        }
    }

    @Override
    public boolean acquireForCommand(InvocationContext ctx, WriteCommand command) throws InterruptedException, TimeoutException {
        if (!this.shouldAcquireLock(ctx, command)) {
            return true;
        }
        return this.acquireLockForWriteCommand(ctx);
    }

    @Override
    public boolean acquireForCommand(TxInvocationContext ctx, PrepareCommand command) throws InterruptedException, TimeoutException {
        if (!this.shouldAcquireLock(ctx, command)) {
            return true;
        }
        return this.acquireLockForWriteCommand(ctx);
    }

    @Override
    public boolean acquireForCommand(TxInvocationContext ctx, CommitCommand command) throws InterruptedException, TimeoutException {
        if (!this.shouldAcquireLock(ctx, command)) {
            return true;
        }
        return this.acquireLockForCommitCommand(ctx);
    }

    @Override
    public boolean acquireForCommand(TxInvocationContext ctx, RollbackCommand command) throws InterruptedException, TimeoutException {
        return true;
    }

    @Override
    public boolean acquireForCommand(TxInvocationContext ctx, LockControlCommand command) throws TimeoutException, InterruptedException {
        if (!this.shouldAcquireLock(ctx, command)) {
            return true;
        }
        return this.acquireLockForWriteCommand(ctx);
    }

    private boolean shouldAcquireLock(InvocationContext ctx, WriteCommand command) {
        return (!ctx.isInTxScope() || this.pessimisticLocking) && !ctx.hasFlag(Flag.SKIP_LOCKING);
    }

    private boolean shouldAcquireLock(TxInvocationContext ctx, PrepareCommand command) {
        return !ctx.hasFlag(Flag.SKIP_LOCKING);
    }

    private boolean shouldAcquireLock(TxInvocationContext ctx, CommitCommand command) {
        return !ctx.hasFlag(Flag.SKIP_LOCKING);
    }

    private boolean shouldAcquireLock(TxInvocationContext ctx, RollbackCommand command) {
        return false;
    }

    private boolean shouldAcquireLock(TxInvocationContext ctx, LockControlCommand command) {
        return !command.isUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForStateTransferToEnd(InvocationContext ctx, VisitableCommand command, int newCacheViewId) throws TimeoutException, InterruptedException {
        boolean shouldSuspendLock;
        if (!this.writesShouldBlock && newCacheViewId <= this.blockingCacheViewId) {
            return;
        }
        try {
            shouldSuspendLock = (Boolean)command.acceptVisitor(ctx, new ShouldAcquireLockVisitor());
        }
        catch (Throwable throwable) {
            throw new CacheException("Unexpected exception", throwable);
        }
        if (shouldSuspendLock) {
            log.tracef("Suspending shared state transfer lock to allow state transfer to start (and end)", new Object[0]);
            this.releaseLockForWrite();
            if (this.blockingCacheViewId < newCacheViewId) {
                long end = System.currentTimeMillis() + this.lockTimeout;
                long timeout = this.lockTimeout;
                Object object = this.lock;
                synchronized (object) {
                    while (timeout >= 0L && this.blockingCacheViewId < newCacheViewId) {
                        if (trace) {
                            log.tracef("We are waiting for cache view %d, right now we have %d", newCacheViewId, this.blockingCacheViewId);
                        }
                        this.lock.wait(timeout);
                        timeout = end - System.currentTimeMillis();
                    }
                }
            }
            this.acquireLockForWriteCommand(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void blockNewTransactions(int cacheViewId) throws InterruptedException {
        log.debugf("Blocking new write commands for cache view %d", cacheViewId);
        Object object = this.lock;
        synchronized (object) {
            this.writesShouldBlock = true;
            if (this.writesBlocked) {
                throw new IllegalStateException("Trying to block write commands but they are already blocked");
            }
            while (this.runningWritesCount.get() != 0) {
                this.lock.wait();
            }
            this.writesBlocked = true;
            this.blockingCacheViewId = cacheViewId;
        }
        log.tracef("New write commands blocked", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unblockNewTransactions(int cacheViewId) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.writesBlocked) {
                throw new IllegalStateException(String.format("Trying to unblock write commands for cache view %d but they were not blocked", cacheViewId));
            }
            this.writesShouldBlock = false;
            this.writesBlocked = false;
            this.lock.notifyAll();
            if (cacheViewId != this.blockingCacheViewId && this.blockingCacheViewId != -1) {
                throw new IllegalStateException(String.format("Trying to unblock write commands for cache view %d, but they were blocked with view id %d", cacheViewId, this.blockingCacheViewId));
            }
        }
        log.debugf("Unblocked write commands for cache view %d", cacheViewId);
    }

    @Override
    public boolean areNewTransactionsBlocked() {
        return this.writesShouldBlock;
    }

    @Override
    public int getBlockingCacheViewId() {
        return this.blockingCacheViewId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean acquireLockForWriteCommand(InvocationContext ctx) throws InterruptedException, TimeoutException {
        if (this.acquireLockForWriteNoWait()) {
            return true;
        }
        if (!ctx.isOriginLocal()) {
            return false;
        }
        long timeout = this.lockTimeout;
        long endTime = System.currentTimeMillis() + this.lockTimeout;
        Object object = this.lock;
        synchronized (object) {
            do {
                this.lock.wait(timeout);
                if (!this.acquireLockForWriteNoWait()) continue;
                return true;
            } while ((timeout = endTime - System.currentTimeMillis()) >= 0L);
            return false;
        }
    }

    private boolean acquireLockForWriteNoWait() {
        if (!this.writesShouldBlock) {
            int previousWrites = this.runningWritesCount.getAndIncrement();
            if (!this.writesShouldBlock) {
                if (trace) {
                    if (this.traceThreadWrites.get() == Boolean.TRUE) {
                        log.error("Trying to acquire state transfer shared lock, but this thread already has it", new Exception());
                    }
                    this.traceThreadWrites.set(Boolean.TRUE);
                    log.tracef("Acquired shared state transfer shared lock, total holders: %d", this.runningWritesCount.get());
                }
                return true;
            }
            this.runningWritesCount.decrementAndGet();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean acquireLockForCommitCommand(InvocationContext ctx) throws InterruptedException, TimeoutException {
        if (this.acquireLockForCommitNoWait()) {
            return true;
        }
        if (!ctx.isOriginLocal()) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            do {
                this.lock.wait();
            } while (!this.acquireLockForCommitNoWait());
            return true;
        }
    }

    private boolean acquireLockForCommitNoWait() {
        if (!this.writesBlocked) {
            int previousWrites = this.runningWritesCount.getAndIncrement();
            if (previousWrites != 0 || !this.writesBlocked) {
                if (trace) {
                    if (this.traceThreadWrites.get() == Boolean.TRUE) {
                        log.error("Trying to acquire state transfer shared lock, but this thread already has it", new Exception());
                    }
                    this.traceThreadWrites.set(Boolean.TRUE);
                    log.tracef("Acquired shared state transfer shared lock (for commit), total holders: %d", this.runningWritesCount.get());
                }
                return true;
            }
            this.runningWritesCount.decrementAndGet();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseLockForWrite() {
        int remainingWrites;
        if (trace) {
            if (this.traceThreadWrites.get() != Boolean.TRUE) {
                log.error("Trying to release state transfer shared lock without acquiring it first", new Exception());
            }
            this.traceThreadWrites.set(null);
        }
        if ((remainingWrites = this.runningWritesCount.decrementAndGet()) < 0) {
            throw new IllegalStateException("Trying to release state transfer shared lock without acquiring it first");
        }
        if (remainingWrites == 0) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
        if (trace) {
            log.tracef("Released shared state transfer shared lock, remaining holders: %d", remainingWrites);
        }
    }

    public String toString() {
        return "StateTransferLockImpl{runningWritesCount=" + this.runningWritesCount + ", writesShouldBlock=" + this.writesShouldBlock + ", writesBlocked=" + this.writesBlocked + ", blockingCacheViewId=" + this.blockingCacheViewId + '}';
    }

    private class ShouldAcquireLockVisitor
    extends AbstractVisitor {
        private ShouldAcquireLockVisitor() {
        }

        @Override
        public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
            return StateTransferLockImpl.this.shouldAcquireLock(ctx, command);
        }

        @Override
        public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
            return StateTransferLockImpl.this.shouldAcquireLock(ctx, command);
        }

        @Override
        public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
            return StateTransferLockImpl.this.shouldAcquireLock(ctx, command);
        }

        @Override
        public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
            return StateTransferLockImpl.this.shouldAcquireLock(ctx, command);
        }

        @Override
        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            return StateTransferLockImpl.this.shouldAcquireLock(ctx, command);
        }

        @Override
        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
            return StateTransferLockImpl.this.shouldAcquireLock(ctx, command);
        }

        @Override
        public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
            return StateTransferLockImpl.this.shouldAcquireLock(ctx, command);
        }

        @Override
        public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
            return StateTransferLockImpl.this.shouldAcquireLock(ctx, command);
        }

        @Override
        public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
            return StateTransferLockImpl.this.shouldAcquireLock(ctx, command);
        }

        @Override
        protected Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
            return Boolean.FALSE;
        }
    }
}

