/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import org.infinispan.util.AbstractFileLookup;
import org.infinispan.util.EnumerationList;
import org.infinispan.util.FileLookup;
import org.infinispan.util.OsgiFileLookup;
import org.infinispan.util.Util;

public class FileLookupFactory {
    public static FileLookup newInstance() {
        ClassLoader cl = FileLookup.class.getClassLoader();
        if (cl.getClass().getName().equals("org.osgi.framework.BundleReference")) {
            return new OsgiFileLookup();
        }
        return new DefaultFileLookup();
    }

    public static class DefaultFileLookup
    extends AbstractFileLookup
    implements FileLookup {
        protected DefaultFileLookup() {
        }

        @Override
        protected InputStream getAsInputStreamFromClassLoader(String filename, ClassLoader appClassLoader) {
            for (ClassLoader cl : Util.getClassLoaders(appClassLoader)) {
                if (cl == null) continue;
                try {
                    return cl.getResourceAsStream(filename);
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        protected URL getAsURLFromClassLoader(String filename, ClassLoader userClassLoader) {
            for (ClassLoader cl : Util.getClassLoaders(userClassLoader)) {
                if (cl == null) continue;
                try {
                    return cl.getResource(filename);
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        protected Collection<URL> getAsURLsFromClassLoader(String filename, ClassLoader userClassLoader) throws IOException {
            HashSet<URL> urls = new HashSet<URL>();
            for (ClassLoader cl : Util.getClassLoaders(userClassLoader)) {
                if (cl == null) continue;
                try {
                    urls.addAll(new EnumerationList<URL>(cl.getResources(filename)));
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
            }
            return urls;
        }
    }
}

