/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.reflect;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.util.ReflectionUtil;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.util.reflect.CachedMethod;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.jandex.MethodInfo;

public class AnnotatedMethodCache {
    private static final Map<String, String[]> FACTORIES = new HashMap<String, String[]>();
    private static final Map<String, List<CachedMethod>> INJECT_METHODS = new HashMap<String, List<CachedMethod>>();
    private static final Map<String, List<CachedMethod>> START_METHODS = new HashMap<String, List<CachedMethod>>();
    private static final Map<String, List<CachedMethod>> STOP_METHODS = new HashMap<String, List<CachedMethod>>();
    private static final Map<String, List<CachedMethod>> INJECT_METHODS_INC_SUB = new ConcurrentHashMap<String, List<CachedMethod>>();
    private static final Map<String, List<CachedMethod>> START_METHODS_INC_SUB = new ConcurrentHashMap<String, List<CachedMethod>>();
    private static final Map<String, List<CachedMethod>> STOP_METHODS_INC_SUB = new ConcurrentHashMap<String, List<CachedMethod>>();
    private static final Log log = LogFactory.getLog(AnnotatedMethodCache.class);

    private static boolean match(Class<?> clazz, String className, ClassLoader classLoader) {
        try {
            return classLoader.loadClass(className).isAssignableFrom(clazz);
        }
        catch (ClassNotFoundException e) {
            log.warn("Cannot load class " + className, e);
            return false;
        }
    }

    private static void collectAndCacheMethodAnnotations(Index annotationIndex, ClassLoader classLoader, DotName annotationType, Map<String, List<CachedMethod>> targetCache) {
        for (AnnotationInstance ai : annotationIndex.getAnnotations(annotationType)) {
            if (!(ai.target() instanceof MethodInfo)) continue;
            MethodInfo methodInfo = (MethodInfo)ai.target();
            ClassInfo classInfo = methodInfo.declaringClass();
            String clazz = classInfo.name().toString();
            List<CachedMethod> methodList = targetCache.get(clazz);
            if (methodList == null) {
                methodList = new LinkedList<CachedMethod>();
                targetCache.put(clazz, methodList);
            }
            try {
                methodList.add(new CachedMethod(ai, classLoader, methodInfo));
            }
            catch (Exception e) {
                log.fatal("Caught exception scanning annotations on " + methodInfo, e);
            }
        }
    }

    public static List<CachedMethod> getInjectMethods(Class<?> clazz, ClassLoader classLoader) {
        return AnnotatedMethodCache.getCachedMethods(clazz, classLoader, INJECT_METHODS, INJECT_METHODS_INC_SUB, Inject.class);
    }

    public static List<CachedMethod> getStartMethods(Class<?> clazz, ClassLoader classLoader) {
        return AnnotatedMethodCache.getCachedMethods(clazz, classLoader, START_METHODS, START_METHODS_INC_SUB, Start.class);
    }

    public static List<CachedMethod> getStopMethods(Class<?> clazz, ClassLoader classLoader) {
        return AnnotatedMethodCache.getCachedMethods(clazz, classLoader, STOP_METHODS, STOP_METHODS_INC_SUB, Stop.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<CachedMethod> getCachedMethods(Class<?> clazz, ClassLoader classLoader, Map<String, List<CachedMethod>> basicMethodCache, Map<String, List<CachedMethod>> richMethodCache, Class<? extends Annotation> annotation) {
        String className = clazz.getName();
        List<CachedMethod> l = richMethodCache.get(className);
        if (l != null) return l;
        Class<AnnotatedMethodCache> clazz2 = AnnotatedMethodCache.class;
        synchronized (AnnotatedMethodCache.class) {
            l = richMethodCache.get(className);
            if (l == null) {
                l = new LinkedList<CachedMethod>();
                for (Map.Entry<String, List<CachedMethod>> e : basicMethodCache.entrySet()) {
                    if (!AnnotatedMethodCache.match(clazz, e.getKey(), classLoader)) continue;
                    l.addAll((Collection<CachedMethod>)e.getValue());
                }
                for (Method m : ReflectionUtil.getAllMethodsShallow(clazz, annotation)) {
                    CachedMethod cm = new CachedMethod(m);
                    if (l.contains(cm)) continue;
                    l.add(cm);
                }
            }
            richMethodCache.put(className, l);
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return l;
        }
    }

    public static Map<String, String[]> getDefaultFactories() {
        return FACTORIES;
    }

    static {
        DotName INJECT_ANNOTATION = DotName.createSimple((String)Inject.class.getName());
        DotName START_ANNOTATION = DotName.createSimple((String)Start.class.getName());
        DotName STOP_ANNOTATION = DotName.createSimple((String)Stop.class.getName());
        DotName FACTORY_FOR_ANNOTATION = DotName.createSimple((String)DefaultFactoryFor.class.getName());
        try {
            ClassLoader classLoader = AnnotatedMethodCache.class.getClassLoader();
            InputStream indexStream = classLoader.getResourceAsStream("infinispan-core-jandex.idx");
            Index annotationIndex = new IndexReader(indexStream).read();
            for (AnnotationInstance ai : annotationIndex.getAnnotations(FACTORY_FOR_ANNOTATION)) {
                if (!(ai.target() instanceof ClassInfo)) continue;
                ClassInfo ci = (ClassInfo)ai.target();
                FACTORIES.put(ci.name().toString(), ai.value("classes").asStringArray());
            }
            AnnotatedMethodCache.collectAndCacheMethodAnnotations(annotationIndex, classLoader, INJECT_ANNOTATION, INJECT_METHODS);
            AnnotatedMethodCache.collectAndCacheMethodAnnotations(annotationIndex, classLoader, START_ANNOTATION, START_METHODS);
            AnnotatedMethodCache.collectAndCacheMethodAnnotations(annotationIndex, classLoader, STOP_ANNOTATION, STOP_METHODS);
        }
        catch (IOException e) {
            log.fatal("Cannot load annotation index!", e);
        }
    }
}

