/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.remoting.AbstractOutboundConnectionAddHandler;
import org.jboss.as.remoting.AbstractOutboundConnectionService;
import org.jboss.as.remoting.GenericOutboundConnectionResourceDefinition;
import org.jboss.as.remoting.GenericOutboundConnectionService;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.remoting3.Endpoint;
import org.xnio.OptionMap;

class GenericOutboundConnectionAdd
extends AbstractOutboundConnectionAddHandler {
    static final GenericOutboundConnectionAdd INSTANCE = new GenericOutboundConnectionAdd();

    static ModelNode getAddOperation(String connectionName, String uri, Map<String, String> connectionCreationOptions) {
        if (connectionName == null || connectionName.trim().isEmpty()) {
            throw new IllegalArgumentException("Connection name cannot be null or empty");
        }
        if (uri == null || uri.trim().isEmpty()) {
            throw new IllegalArgumentException("Connection URI cannot be null for connection named " + connectionName);
        }
        ModelNode addOperation = new ModelNode();
        addOperation.get("operation").set("add");
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"remoting"), PathElement.pathElement((String)"outbound-connection", (String)connectionName)});
        addOperation.get("address").set(address.toModelNode());
        addOperation.get("uri").set(uri);
        if (connectionCreationOptions != null) {
            for (Map.Entry<String, String> entry : connectionCreationOptions.entrySet()) {
                if (entry.getKey() == null) continue;
                addOperation.get("connection-creation-options").set(entry.getKey(), entry.getValue());
            }
        }
        return addOperation;
    }

    private GenericOutboundConnectionAdd() {
    }

    @Override
    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        super.populateModel(operation, model);
        GenericOutboundConnectionResourceDefinition.URI.validateAndSet(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        String name = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        ServiceController serviceController = this.installRuntimeService(context, name, model, verificationHandler);
        newControllers.add(serviceController);
    }

    ServiceController installRuntimeService(OperationContext context, String connectionName, ModelNode outboundConnection, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
        OptionMap connectionCreationOptions = GenericOutboundConnectionAdd.getConnectionCreationOptions(outboundConnection);
        URI uri = this.getDestinationURI(context, outboundConnection);
        GenericOutboundConnectionService outboundRemotingConnectionService = new GenericOutboundConnectionService(connectionName, uri, connectionCreationOptions);
        ServiceName serviceName = AbstractOutboundConnectionService.OUTBOUND_CONNECTION_BASE_SERVICE_NAME.append(new String[]{connectionName});
        ServiceName aliasServiceName = GenericOutboundConnectionService.GENERIC_OUTBOUND_CONNECTION_BASE_SERVICE_NAME.append(new String[]{connectionName});
        ServiceBuilder svcBuilder = context.getServiceTarget().addService(serviceName, (Service)outboundRemotingConnectionService).addAliases(new ServiceName[]{aliasServiceName}).addDependency(RemotingServices.SUBSYSTEM_ENDPOINT, Endpoint.class, outboundRemotingConnectionService.getEnpointInjector());
        if (verificationHandler != null) {
            svcBuilder.addListener((ServiceListener)verificationHandler);
        }
        return svcBuilder.install();
    }

    URI getDestinationURI(OperationContext context, ModelNode outboundConnection) throws OperationFailedException {
        String uri = GenericOutboundConnectionResourceDefinition.URI.resolveModelAttribute(context, outboundConnection).asString();
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new OperationFailedException(new ModelNode().set("Cannot create a valid URI from " + uri + " -- " + e.toString()));
        }
    }
}

