/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.webservices.dmr.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

final class WSSubsystemProviders {
    static final String RESOURCE_NAME = WSSubsystemProviders.class.getPackage().getName() + ".LocalDescriptions";
    static final DescriptionProvider SUBSYSTEM = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getSubsystem(locale);
        }
    };
    static final DescriptionProvider SUBSYSTEM_ADD = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getSubsystemAdd(locale);
        }
    };
    static final DescriptionProvider SUBSYSTEM_DESCRIBE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return CommonDescriptions.getSubsystemDescribeOperation((Locale)locale);
        }
    };
    static final DescriptionProvider SUBSYSTEM_REMOVE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getSubsystemRemoveDescription(locale);
        }
    };
    static final DescriptionProvider DEPLOYMENT_DESCRIPTION = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getDeploymentDescription(locale);
        }
    };
    static final DescriptionProvider ENDPOINT_DESCRIPTION = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getEndpointDescription(locale);
        }
    };
    static final DescriptionProvider ENDPOINT_ADD_DESCRIPTION = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getEndpointAddDescription(locale);
        }
    };
    static final DescriptionProvider ENDPOINT_REMOVE_DESCRIPTION = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getEndpointRemoveDescription(locale);
        }
    };
    static final DescriptionProvider ENDPOINTCONFIG_DESCRIPTION = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getEndpointConfigDescription(locale);
        }
    };
    static final DescriptionProvider ENDPOINTCONFIG_ADD_DESCRIPTION = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getEndpointConfigAddDescription(locale);
        }
    };
    static final DescriptionProvider ENDPOINTCONFIG_REMOVE_DESCRIPTION = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getEndpointConfigRemoveDescription(locale);
        }
    };

    private WSSubsystemProviders() {
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        return ResourceBundle.getBundle(RESOURCE_NAME, locale == null ? Locale.getDefault() : locale);
    }

    private static class Descriptions {
        private Descriptions() {
        }

        static ModelNode getSubsystem(Locale locale) {
            ResourceBundle bundle2 = WSSubsystemProviders.getResourceBundle(locale);
            ModelNode subsystem = new ModelNode();
            subsystem.get("description").set(bundle2.getString("ws"));
            subsystem.get("head-comment-allowed").set(true);
            subsystem.get("tail-comment-allowed").set(true);
            subsystem.get("namespace").set(Namespace.WEBSERVICES_1_0.getUriString());
            subsystem.get(new String[]{"attributes", "modify-wsdl-address", "description"}).set(bundle2.getString("modify.wsdl.address"));
            subsystem.get(new String[]{"attributes", "modify-wsdl-address", "type"}).set(ModelType.BOOLEAN);
            subsystem.get(new String[]{"attributes", "modify-wsdl-address", "required"}).set(true);
            subsystem.get(new String[]{"attributes", "wsdl-host", "description"}).set(bundle2.getString("wsdl.host"));
            subsystem.get(new String[]{"attributes", "wsdl-host", "type"}).set(ModelType.STRING);
            subsystem.get(new String[]{"attributes", "wsdl-host", "required"}).set(true);
            subsystem.get(new String[]{"attributes", "wsdl-port", "description"}).set(bundle2.getString("wsdl.port"));
            subsystem.get(new String[]{"attributes", "wsdl-port", "type"}).set(ModelType.INT);
            subsystem.get(new String[]{"attributes", "wsdl-port", "required"}).set(false);
            subsystem.get(new String[]{"attributes", "wsdl-secure-port", "description"}).set(bundle2.getString("wsdl.secure.port"));
            subsystem.get(new String[]{"attributes", "wsdl-secure-port", "type"}).set(ModelType.INT);
            subsystem.get(new String[]{"attributes", "wsdl-secure-port", "required"}).set(false);
            subsystem.get(new String[]{"children", "endpoint-config", "description"}).set(bundle2.getString("endpoint.config"));
            subsystem.get(new String[]{"children", "endpoint", "description"}).set(bundle2.getString("endpoint"));
            subsystem.get(new String[]{"children", "endpoint", "required"}).set(false);
            return subsystem;
        }

        static ModelNode getEndpointAddDescription(Locale locale) {
            ResourceBundle bundle2 = WSSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("add");
            operation.get("description").set(bundle2.getString("endpoint.add"));
            operation.get(new String[]{"request-properties", "name", "description"}).set(bundle2.getString("endpoint.name"));
            operation.get(new String[]{"request-properties", "name", "type"}).set(ModelType.STRING);
            operation.get(new String[]{"request-properties", "name", "required"}).set(true);
            operation.get(new String[]{"request-properties", "context", "description"}).set(bundle2.getString("endpoint.context"));
            operation.get(new String[]{"request-properties", "context", "type"}).set(ModelType.STRING);
            operation.get(new String[]{"request-properties", "context", "required"}).set(true);
            operation.get(new String[]{"request-properties", "class", "description"}).set(bundle2.getString("endpoint.class"));
            operation.get(new String[]{"request-properties", "class", "type"}).set(ModelType.STRING);
            operation.get(new String[]{"request-properties", "class", "required"}).set(false);
            operation.get(new String[]{"request-properties", "type", "description"}).set(bundle2.getString("endpoint.type"));
            operation.get(new String[]{"request-properties", "type", "type"}).set(ModelType.STRING);
            operation.get(new String[]{"request-properties", "type", "required"}).set(false);
            operation.get(new String[]{"request-properties", "wsdl-url", "description"}).set(bundle2.getString("endpoint.wsdl"));
            operation.get(new String[]{"request-properties", "wsdl-url", "type"}).set(ModelType.STRING);
            operation.get(new String[]{"request-properties", "wsdl-url", "required"}).set(false);
            operation.get("reply-properties").setEmptyObject();
            return operation;
        }

        static ModelNode getEndpointRemoveDescription(Locale locale) {
            ResourceBundle bundle2 = WSSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("remove");
            operation.get("description").set(bundle2.getString("endpoint.remove"));
            operation.get(new String[]{"request-properties", "name", "description"}).set(bundle2.getString("endpoint.name"));
            operation.get(new String[]{"request-properties", "name", "type"}).set(ModelType.STRING);
            operation.get(new String[]{"request-properties", "name", "required"}).set(true);
            operation.get("reply-properties").setEmptyObject();
            return operation;
        }

        static ModelNode getDeploymentDescription(Locale locale) {
            ResourceBundle bundle2 = WSSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("description").set(bundle2.getString("deployment"));
            node.get("attributes").setEmptyObject();
            node.get("operations");
            node.get(new String[]{"children", "endpoint", "description"}).set(bundle2.getString("endpoint"));
            node.get(new String[]{"children", "endpoint", "min-occurs"}).set(0);
            node.get(new String[]{"children", "endpoint", "model-description"});
            return node;
        }

        static ModelNode getEndpointDescription(Locale locale) {
            ResourceBundle bundle2 = WSSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("description").set(bundle2.getString("endpoint"));
            node.get("head-comment-allowed").set(true);
            node.get("tail-comment-allowed").set(true);
            node.get(new String[]{"attributes", "name", "description"}).set(bundle2.getString("endpoint.name"));
            node.get(new String[]{"attributes", "name", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "name", "required"}).set(true);
            node.get(new String[]{"attributes", "context", "description"}).set(bundle2.getString("endpoint.context"));
            node.get(new String[]{"attributes", "context", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "context", "required"}).set(true);
            node.get(new String[]{"attributes", "class", "description"}).set(bundle2.getString("endpoint.class"));
            node.get(new String[]{"attributes", "class", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "class", "required"}).set(false);
            node.get(new String[]{"attributes", "type", "description"}).set(bundle2.getString("endpoint.type"));
            node.get(new String[]{"attributes", "type", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "type", "required"}).set(false);
            node.get(new String[]{"attributes", "wsdl-url", "description"}).set(bundle2.getString("endpoint.wsdl"));
            node.get(new String[]{"attributes", "wsdl-url", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "wsdl-url", "required"}).set(false);
            node.get(new String[]{"attributes", "average-processing-time", "description"}).set(bundle2.getString("average.processing.time"));
            node.get(new String[]{"attributes", "average-processing-time", "type"}).set(ModelType.INT);
            node.get(new String[]{"attributes", "average-processing-time", "required"}).set(false);
            node.get(new String[]{"attributes", "min-processing-time", "description"}).set(bundle2.getString("min.processing.time"));
            node.get(new String[]{"attributes", "min-processing-time", "type"}).set(ModelType.INT);
            node.get(new String[]{"attributes", "min-processing-time", "required"}).set(false);
            node.get(new String[]{"attributes", "max-processing-time", "description"}).set(bundle2.getString("max.processing.time"));
            node.get(new String[]{"attributes", "max-processing-time", "type"}).set(ModelType.INT);
            node.get(new String[]{"attributes", "max-processing-time", "required"}).set(false);
            node.get(new String[]{"attributes", "total-processing-time", "description"}).set(bundle2.getString("total.processing.time"));
            node.get(new String[]{"attributes", "total-processing-time", "type"}).set(ModelType.INT);
            node.get(new String[]{"attributes", "total-processing-time", "required"}).set(false);
            node.get(new String[]{"attributes", "request-count", "description"}).set(bundle2.getString("request.count"));
            node.get(new String[]{"attributes", "request-count", "type"}).set(ModelType.INT);
            node.get(new String[]{"attributes", "request-count", "required"}).set(false);
            node.get(new String[]{"attributes", "response-count", "description"}).set(bundle2.getString("response.count"));
            node.get(new String[]{"attributes", "response-count", "type"}).set(ModelType.INT);
            node.get(new String[]{"attributes", "response-count", "required"}).set(false);
            node.get(new String[]{"attributes", "fault-count", "description"}).set(bundle2.getString("fault.count"));
            node.get(new String[]{"attributes", "fault-count", "type"}).set(ModelType.INT);
            node.get(new String[]{"attributes", "fault-count", "required"}).set(false);
            return node;
        }

        static ModelNode getEndpointConfigDescription(Locale locale) {
            ResourceBundle bundle2 = WSSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("description").set(bundle2.getString("endpoint.config"));
            node.get("head-comment-allowed").set(true);
            node.get("tail-comment-allowed").set(true);
            node.get(new String[]{"attributes", "config-name", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "config-name", "description"}).set(bundle2.getString("endpoint.config.name"));
            node.get(new String[]{"attributes", "config-name", "required"}).set(true);
            node.get(new String[]{"attributes", "pre-handler-chains", "handler-chain", "protocol-bindings", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "pre-handler-chains", "handler-chain", "protocol-bindings", "description"}).set(bundle2.getString("protocol.binding"));
            node.get(new String[]{"attributes", "pre-handler-chains", "handler-chain", "protocol-bindings", "required"}).set(false);
            node.get(new String[]{"attributes", "pre-handler-chains", "handler-chain", "port-name-pattern", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "pre-handler-chains", "handler-chain", "port-name-pattern", "description"}).set(bundle2.getString("portname.pattern"));
            node.get(new String[]{"attributes", "pre-handler-chains", "handler-chain", "port-name-pattern", "required"}).set(false);
            node.get(new String[]{"attributes", "pre-handler-chains", "handler-chain", "service-name-pattern", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "pre-handler-chains", "handler-chain", "service-name-pattern", "description"}).set(bundle2.getString("servicename.pattern"));
            node.get(new String[]{"attributes", "pre-handler-chains", "handler-chain", "service-name-pattern", "required"}).set(false);
            node.get(new String[]{"attributes", "pre-handler-chains", "handler-chain", "handler", "handler-name", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "pre-handler-chains", "handler-chain", "handler", "handler-name", "description"}).set(bundle2.getString("handler.name"));
            node.get(new String[]{"attributes", "pre-handler-chains", "handler-chain", "handler", "handler-name", "required"}).set(true);
            node.get(new String[]{"attributes", "pre-handler-chains", "handler-chain", "handler", "handler-class", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "pre-handler-chains", "handler-chain", "handler", "handler-class", "description"}).set(bundle2.getString("handler.class"));
            node.get(new String[]{"attributes", "pre-handler-chains", "handler-chain", "handler", "handler-class", "required"}).set(true);
            node.get(new String[]{"attributes", "post-handler-chains", "handler-chain", "protocol-bindings", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "post-handler-chains", "handler-chain", "protocol-bindings", "description"}).set(bundle2.getString("protocol.binding"));
            node.get(new String[]{"attributes", "post-handler-chains", "handler-chain", "protocol-bindings", "required"}).set(false);
            node.get(new String[]{"attributes", "post-handler-chains", "handler-chain", "port-name-pattern", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "post-handler-chains", "handler-chain", "port-name-pattern", "description"}).set(bundle2.getString("portname.pattern"));
            node.get(new String[]{"attributes", "post-handler-chains", "handler-chain", "port-name-pattern", "required"}).set(false);
            node.get(new String[]{"attributes", "post-handler-chains", "handler-chain", "service-name-pattern", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "post-handler-chains", "handler-chain", "service-name-pattern", "description"}).set(bundle2.getString("servicename.pattern"));
            node.get(new String[]{"attributes", "post-handler-chains", "handler-chain", "service-name-pattern", "required"}).set(false);
            node.get(new String[]{"attributes", "post-handler-chains", "handler-chain", "handler", "handler-name", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "post-handler-chains", "handler-chain", "handler", "handler-name", "description"}).set(bundle2.getString("handler.name"));
            node.get(new String[]{"attributes", "post-handler-chains", "handler-chain", "handler", "handler-name", "required"}).set(true);
            node.get(new String[]{"attributes", "post-handler-chains", "handler-chain", "handler", "handler-class", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "post-handler-chains", "handler-chain", "handler", "handler-class", "description"}).set(bundle2.getString("handler.class"));
            node.get(new String[]{"attributes", "post-handler-chains", "handler-chain", "handler", "handler-class", "required"}).set(true);
            node.get(new String[]{"attributes", "property", "property-name", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "property", "property-name", "description"}).set(bundle2.getString("property.name"));
            node.get(new String[]{"attributes", "property", "property-name", "required"}).set(true);
            node.get(new String[]{"attributes", "property", "property-value", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "property", "property-value", "description"}).set(bundle2.getString("property.value"));
            node.get(new String[]{"attributes", "property", "property-value", "required"}).set(true);
            node.get(new String[]{"attributes", "feature", "feature-name", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "feature", "feature-name", "description"}).set(bundle2.getString("feature.name"));
            node.get(new String[]{"attributes", "feature", "feature-name", "required"}).set(true);
            return node;
        }

        static ModelNode getEndpointConfigAddDescription(Locale locale) {
            ResourceBundle bundle2 = WSSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("operation-name").set("add");
            node.get("description").set(bundle2.getString("endpoint.config.add"));
            node.get(new String[]{"request-properties", "config-name", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "config-name", "description"}).set(bundle2.getString("endpoint.config.name"));
            node.get(new String[]{"request-properties", "config-name", "required"}).set(true);
            node.get(new String[]{"request-properties", "pre-handler-chains", "handler-chain", "protocol-bindings", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "pre-handler-chains", "handler-chain", "protocol-bindings", "description"}).set(bundle2.getString("protocol.binding"));
            node.get(new String[]{"request-properties", "pre-handler-chains", "handler-chain", "protocol-bindings", "required"}).set(false);
            node.get(new String[]{"request-properties", "pre-handler-chains", "handler-chain", "port-name-pattern", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "pre-handler-chains", "handler-chain", "port-name-pattern", "description"}).set(bundle2.getString("portname.pattern"));
            node.get(new String[]{"request-properties", "pre-handler-chains", "handler-chain", "port-name-pattern", "required"}).set(false);
            node.get(new String[]{"request-properties", "pre-handler-chains", "handler-chain", "service-name-pattern", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "pre-handler-chains", "handler-chain", "service-name-pattern", "description"}).set(bundle2.getString("servicename.pattern"));
            node.get(new String[]{"request-properties", "pre-handler-chains", "handler-chain", "service-name-pattern", "required"}).set(false);
            node.get(new String[]{"request-properties", "pre-handler-chains", "handler-chain", "handler", "handler-name", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "pre-handler-chains", "handler-chain", "handler", "handler-name", "description"}).set(bundle2.getString("handler.name"));
            node.get(new String[]{"request-properties", "pre-handler-chains", "handler-chain", "handler", "handler-name", "required"}).set(true);
            node.get(new String[]{"request-properties", "pre-handler-chains", "handler-chain", "handler", "handler-class", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "pre-handler-chains", "handler-chain", "handler", "handler-class", "description"}).set(bundle2.getString("handler.class"));
            node.get(new String[]{"request-properties", "pre-handler-chains", "handler-chain", "handler", "handler-class", "required"}).set(true);
            node.get(new String[]{"request-properties", "post-handler-chains", "handler-chain", "protocol-bindings", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "post-handler-chains", "handler-chain", "protocol-bindings", "description"}).set(bundle2.getString("protocol.binding"));
            node.get(new String[]{"request-properties", "post-handler-chains", "handler-chain", "protocol-bindings", "required"}).set(false);
            node.get(new String[]{"request-properties", "post-handler-chains", "handler-chain", "port-name-pattern", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "post-handler-chains", "handler-chain", "port-name-pattern", "description"}).set(bundle2.getString("portname.pattern"));
            node.get(new String[]{"request-properties", "post-handler-chains", "handler-chain", "port-name-pattern", "required"}).set(false);
            node.get(new String[]{"request-properties", "post-handler-chains", "handler-chain", "service-name-pattern", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "post-handler-chains", "handler-chain", "service-name-pattern", "description"}).set(bundle2.getString("servicename.pattern"));
            node.get(new String[]{"request-properties", "post-handler-chains", "handler-chain", "service-name-pattern", "required"}).set(false);
            node.get(new String[]{"request-properties", "post-handler-chains", "handler-chain", "handler", "handler-name", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "post-handler-chains", "handler-chain", "handler", "handler-name", "description"}).set(bundle2.getString("handler.name"));
            node.get(new String[]{"request-properties", "post-handler-chains", "handler-chain", "handler", "handler-name", "required"}).set(true);
            node.get(new String[]{"request-properties", "post-handler-chains", "handler-chain", "handler", "handler-class", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "post-handler-chains", "handler-chain", "handler", "handler-class", "description"}).set(bundle2.getString("handler.class"));
            node.get(new String[]{"request-properties", "post-handler-chains", "handler-chain", "handler", "handler-class", "required"}).set(true);
            node.get(new String[]{"request-properties", "property", "property-name", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "property", "property-name", "description"}).set(bundle2.getString("property.name"));
            node.get(new String[]{"request-properties", "property", "property-name", "required"}).set(true);
            node.get(new String[]{"request-properties", "property", "property-value", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "property", "property-value", "description"}).set(bundle2.getString("property.value"));
            node.get(new String[]{"request-properties", "property", "property-value", "required"}).set(true);
            node.get(new String[]{"request-properties", "feature", "feature-name", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "feature", "feature-name", "description"}).set(bundle2.getString("feature.name"));
            node.get(new String[]{"request-properties", "feature", "feature-name", "required"}).set(true);
            return node;
        }

        static ModelNode getEndpointConfigRemoveDescription(Locale locale) {
            ResourceBundle bundle2 = WSSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("operation-name").set("remove");
            node.get("description").set(bundle2.getString("endpoint.config.remove"));
            node.get(new String[]{"request-properties", "name", "description"}).set(bundle2.getString("endpoint.config.name"));
            node.get(new String[]{"request-properties", "name", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "name", "required"}).set(true);
            node.get("reply-properties").setEmptyObject();
            return node;
        }

        static ModelNode getSubsystemAdd(Locale locale) {
            ResourceBundle bundle2 = WSSubsystemProviders.getResourceBundle(locale);
            ModelNode op = new ModelNode();
            op.get("operation-name").set("add");
            op.get("description").set(bundle2.getString("ws.add"));
            op.get(new String[]{"request-properties", "modify-wsdl-address", "description"}).set(bundle2.getString("modify.wsdl.address"));
            op.get(new String[]{"request-properties", "modify-wsdl-address", "type"}).set(ModelType.BOOLEAN);
            op.get(new String[]{"request-properties", "modify-wsdl-address", "required"}).set(true);
            op.get(new String[]{"request-properties", "wsdl-host", "description"}).set(bundle2.getString("wsdl.host"));
            op.get(new String[]{"request-properties", "wsdl-host", "type"}).set(ModelType.STRING);
            op.get(new String[]{"request-properties", "wsdl-host", "required"}).set(true);
            op.get(new String[]{"request-properties", "wsdl-port", "description"}).set(bundle2.getString("wsdl.port"));
            op.get(new String[]{"request-properties", "wsdl-port", "type"}).set(ModelType.INT);
            op.get(new String[]{"request-properties", "wsdl-port", "required"}).set(false);
            op.get(new String[]{"request-properties", "wsdl-secure-port", "description"}).set(bundle2.getString("wsdl.secure.port"));
            op.get(new String[]{"request-properties", "wsdl-secure-port", "type"}).set(ModelType.INT);
            op.get(new String[]{"request-properties", "wsdl-secure-port", "required"}).set(false);
            op.get("reply-properties").setEmptyObject();
            return op;
        }

        static ModelNode getSubsystemRemoveDescription(Locale locale) {
            ResourceBundle bundle2 = WSSubsystemProviders.getResourceBundle(locale);
            ModelNode op = new ModelNode();
            op.get("operation-name").set("remove");
            op.get("description").set(bundle2.getString("ws.remove"));
            op.get("reply-properties").setEmptyObject();
            op.get("request-properties").setEmptyObject();
            return op;
        }
    }
}

