/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.subsystem;

import java.util.List;
import java.util.Locale;
import org.jboss.as.cmp.component.CmpEntityBeanComponentDescription;
import org.jboss.as.cmp.keygenerator.KeyGeneratorFactoryRegistry;
import org.jboss.as.cmp.processors.CmpDependencyProcessor;
import org.jboss.as.cmp.processors.CmpEntityBeanComponentDescriptionFactory;
import org.jboss.as.cmp.processors.CmpEntityMetaDataProcessor;
import org.jboss.as.cmp.processors.CmpParsingProcessor;
import org.jboss.as.cmp.processors.CmpStoreManagerProcessor;
import org.jboss.as.cmp.subsystem.CmpSubsystemDescriptions;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;

public class CmpSubsystemAdd
extends AbstractBoottimeAddStepHandler
implements DescriptionProvider {
    private static final Logger logger = Logger.getLogger(CmpSubsystemAdd.class);
    static CmpSubsystemAdd INSTANCE = new CmpSubsystemAdd();

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        logger.info((Object)"Activating EJB CMP Subsystem");
        final boolean appclient = context.getProcessType() == ProcessType.APPLICATION_CLIENT;
        KeyGeneratorFactoryRegistry keyGeneratorFactoryRegistry = new KeyGeneratorFactoryRegistry();
        newControllers.add(context.getServiceTarget().addService(KeyGeneratorFactoryRegistry.SERVICE_NAME, (Service)keyGeneratorFactoryRegistry).addListener((ServiceListener)verificationHandler).install());
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor(Phase.PARSE, 4435, (DeploymentUnitProcessor)new CmpEntityBeanComponentDescriptionFactory(appclient));
                if (!appclient) {
                    processorTarget.addDeploymentProcessor(Phase.DEPENDENCIES, 5376, (DeploymentUnitProcessor)new CmpDependencyProcessor());
                    processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 8960, (DeploymentUnitProcessor)new CmpParsingProcessor());
                    processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 9216, (DeploymentUnitProcessor)new CmpEntityMetaDataProcessor(CmpEntityBeanComponentDescription.class));
                    processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 9472, (DeploymentUnitProcessor)new CmpStoreManagerProcessor());
                }
            }
        }, OperationContext.Stage.RUNTIME);
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        model.setEmptyObject();
    }

    public ModelNode getModelDescription(Locale locale) {
        return CmpSubsystemDescriptions.getSubystemAddDescription(locale);
    }
}

