/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache.impl.backing;

import java.io.Serializable;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.cache.Cacheable;
import org.jboss.as.ejb3.cache.spi.BackingCacheEntry;
import org.jboss.as.ejb3.cache.spi.BackingCacheEntryStore;
import org.jboss.as.ejb3.cache.spi.BackingCacheEntryStoreConfig;
import org.jboss.as.ejb3.cache.spi.GroupCompatibilityChecker;
import org.jboss.as.ejb3.cache.spi.PersistentObjectStore;
import org.jboss.as.ejb3.cache.spi.impl.AbstractBackingCacheEntryStore;
import org.jboss.as.ejb3.cache.spi.impl.CacheableTimestamp;
import org.jboss.as.ejb3.component.stateful.StatefulTimeoutInfo;

public class SimpleBackingCacheEntryStore<K extends Serializable, V extends Cacheable<K>, E extends BackingCacheEntry<K, V>>
extends AbstractBackingCacheEntryStore<K, V, E> {
    private final PersistentObjectStore<K, E> store;
    private final Map<K, E> cache = new ConcurrentHashMap<K, E>();
    private final SortedSet<CacheableTimestamp<K>> entries = new ConcurrentSkipListSet<CacheableTimestamp<K>>();

    public SimpleBackingCacheEntryStore(PersistentObjectStore<K, E> store, StatefulTimeoutInfo timeout, BackingCacheEntryStoreConfig config) {
        super(timeout, config);
        this.store = store;
    }

    @Override
    public boolean isClustered() {
        return false;
    }

    @Override
    public E get(K key) {
        BackingCacheEntry entry = (BackingCacheEntry)this.cache.get(key);
        if (entry == null && (entry = (BackingCacheEntry)this.store.load(key)) != null) {
            this.cache.put(key, entry);
            this.add(entry);
        }
        return (E)entry;
    }

    @Override
    public void insert(E entry) {
        Serializable key = (Serializable)entry.getId();
        if (this.cache.containsKey(key)) {
            throw EjbMessages.MESSAGES.duplicateCacheEntry(key);
        }
        this.cache.put(key, entry);
        this.add(entry);
    }

    @Override
    public void update(E entry, boolean modified) {
        Serializable key = (Serializable)entry.getId();
        if (!this.cache.containsKey(key)) {
            throw EjbMessages.MESSAGES.missingCacheEntry(key);
        }
        this.update(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void passivate(E entry) {
        E e = entry;
        synchronized (e) {
            Serializable key = (Serializable)entry.getId();
            this.store.store(entry);
            this.cache.remove(key);
            this.remove(entry);
        }
    }

    @Override
    public E remove(K id) {
        E entry = this.get(id);
        if (entry != null) {
            this.cache.remove(id);
            this.remove(entry);
        }
        return entry;
    }

    @Override
    private void remove(E entry) {
        this.entries.remove(new CacheableTimestamp(entry));
    }

    private void update(E entry) {
        CacheableTimestamp timestamp = new CacheableTimestamp(entry);
        this.entries.remove(timestamp);
        this.add(timestamp);
    }

    private void add(E entry) {
        CacheableTimestamp timestamp = new CacheableTimestamp(entry);
        this.add(timestamp);
    }

    private void add(CacheableTimestamp<K> timestamp) {
        this.entries.remove(timestamp);
        this.entries.add(timestamp);
        int maxSize = this.getConfig().getMaxSize();
        while (this.entries.size() > maxSize) {
            BackingCacheEntry entry = (BackingCacheEntry)this.cache.get(this.entries.first().getId());
            if (entry == null) continue;
            this.passivate(entry);
        }
    }

    @Override
    public void start() {
        this.store.start();
    }

    @Override
    public void stop() {
        this.store.stop();
    }

    @Override
    public boolean isCompatibleWith(GroupCompatibilityChecker other) {
        if (other instanceof BackingCacheEntryStore) {
            return !((BackingCacheEntryStore)other).isClustered();
        }
        return false;
    }
}

