/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache.spi.impl;

import java.io.Serializable;
import javax.ejb.NoSuchEJBException;
import org.jboss.as.ejb3.cache.Cache;
import org.jboss.as.ejb3.cache.Cacheable;
import org.jboss.as.ejb3.cache.spi.BackingCache;
import org.jboss.as.ejb3.cache.spi.BackingCacheEntry;

public abstract class AbstractCache<K extends Serializable, V extends Cacheable<K>, E extends BackingCacheEntry<K, V>>
implements Cache<K, V> {
    private final BackingCache<K, V, E> backingCache;

    protected AbstractCache(BackingCache<K, V, E> backingCache) {
        this.backingCache = backingCache;
    }

    @Override
    public V create() {
        return this.backingCache.create().getUnderlyingItem();
    }

    @Override
    public void discard(K key) {
        this.backingCache.discard(key);
    }

    @Override
    public V get(K key) throws NoSuchEJBException {
        E entry = this.backingCache.get(key);
        return entry != null ? (V)entry.getUnderlyingItem() : null;
    }

    @Override
    public void release(V object) {
        this.backingCache.release((Serializable)object.getId());
    }

    @Override
    public void remove(K key) {
        this.backingCache.remove(key);
    }

    @Override
    public void start() {
        this.backingCache.start();
    }

    @Override
    public void stop() {
        this.backingCache.stop();
    }
}

