/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.pool.strictmax;

import java.util.LinkedList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.pool.AbstractPool;
import org.jboss.as.ejb3.pool.StatelessObjectFactory;

public class StrictMaxPool<T>
extends AbstractPool<T> {
    private final Semaphore semaphore;
    private final int maxSize;
    private final long timeout;
    private final TimeUnit timeUnit;
    private final LinkedList<T> pool = new LinkedList();
    private int inUse = 0;

    public StrictMaxPool(StatelessObjectFactory<T> factory, int maxSize, long timeout, TimeUnit timeUnit) {
        super(factory);
        this.maxSize = maxSize;
        this.semaphore = new Semaphore(maxSize, true);
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    @Override
    public void discard(T ctx) {
        if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
            EjbLogger.ROOT_LOGGER.tracef("Discard instance %s#%s", this, ctx);
        }
        this.semaphore.release();
        --this.inUse;
        super.doRemove(ctx);
    }

    @Override
    public int getCurrentSize() {
        return this.getCreateCount() - this.getRemoveCount();
    }

    @Override
    public int getAvailableCount() {
        return this.maxSize - this.inUse;
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public void setMaxSize(int maxSize) {
        throw EjbMessages.MESSAGES.methodNotImplemented();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        try {
            boolean acquired = this.semaphore.tryAcquire(this.timeout, this.timeUnit);
            if (!acquired) {
                throw EjbMessages.MESSAGES.failedToAcquirePermit(this.timeout, this.timeUnit);
            }
        }
        catch (InterruptedException e) {
            throw EjbMessages.MESSAGES.acquireSemaphoreInterrupted();
        }
        LinkedList<T> e = this.pool;
        synchronized (e) {
            if (!this.pool.isEmpty()) {
                return this.pool.removeFirst();
            }
        }
        T bean = null;
        try {
            ++this.inUse;
            bean = this.create();
        }
        finally {
            if (bean == null) {
                --this.inUse;
                this.semaphore.release();
            }
        }
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(T obj) {
        if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
            EjbLogger.ROOT_LOGGER.tracef("%s/%s Free instance: %s", this.pool.size(), this.maxSize, this);
        }
        boolean destroyIt = false;
        LinkedList<T> linkedList = this.pool;
        synchronized (linkedList) {
            if (this.pool.size() < this.maxSize) {
                this.pool.add(obj);
            } else {
                destroyIt = true;
            }
        }
        if (destroyIt) {
            this.destroy(obj);
        }
        this.semaphore.release();
        --this.inUse;
    }

    @Override
    public void remove(T ctx) {
        if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
            EjbLogger.ROOT_LOGGER.tracef("Removing instance: %s#%s", this, ctx);
        }
        this.semaphore.release();
        --this.inUse;
        super.doRemove(ctx);
    }

    @Override
    public void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        LinkedList<T> linkedList = this.pool;
        synchronized (linkedList) {
            for (Object obj : this.pool) {
                this.destroy(obj);
            }
            this.pool.clear();
        }
    }
}

