/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.deployment.DeploymentRepository;
import org.jboss.as.ejb3.remote.EJBRemoteTransactionsRepository;
import org.jboss.as.ejb3.remote.protocol.versionone.VersionOneProtocolChannelReceiver;
import org.jboss.ejb.client.remoting.PackedInteger;
import org.jboss.logging.Logger;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remoting3.OpenListener;
import org.jboss.remoting3.Registration;
import org.jboss.remoting3.ServiceRegistrationException;
import org.xnio.IoUtils;
import org.xnio.OptionMap;

public class EJBRemoteConnectorService
implements Service<EJBRemoteConnectorService> {
    private static final Logger log = Logger.getLogger(EJBRemoteConnectorService.class);
    private static final String EJB_CHANNEL_NAME = "jboss.ejb";
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb3", "connector"});
    private final InjectedValue<Endpoint> endpointValue = new InjectedValue();
    private final InjectedValue<ExecutorService> executorService = new InjectedValue();
    private final InjectedValue<DeploymentRepository> deploymentRepositoryInjectedValue = new InjectedValue();
    private final InjectedValue<EJBRemoteTransactionsRepository> ejbRemoteTransactionsRepositoryInjectedValue = new InjectedValue();
    private volatile Registration registration;
    private final byte serverProtocolVersion;
    private final String[] supportedMarshallingStrategies;

    public EJBRemoteConnectorService(byte serverProtocolVersion, String[] supportedMarshallingStrategies) {
        this.serverProtocolVersion = serverProtocolVersion;
        this.supportedMarshallingStrategies = supportedMarshallingStrategies;
    }

    public void start(StartContext context) throws StartException {
        ServiceContainer serviceContainer = context.getController().getServiceContainer();
        ChannelOpenListener channelOpenListener = new ChannelOpenListener(serviceContainer);
        try {
            this.registration = ((Endpoint)this.endpointValue.getValue()).registerService(EJB_CHANNEL_NAME, (OpenListener)channelOpenListener, OptionMap.EMPTY);
        }
        catch (ServiceRegistrationException e) {
            throw new StartException((Throwable)e);
        }
    }

    public void stop(StopContext context) {
        this.registration.close();
    }

    public EJBRemoteConnectorService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<Endpoint> getEndpointInjector() {
        return this.endpointValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendVersionMessage(Channel channel) throws IOException {
        DataOutputStream outputStream = new DataOutputStream((OutputStream)channel.writeMessage());
        try {
            outputStream.write(this.serverProtocolVersion);
            PackedInteger.writePackedInteger((DataOutput)outputStream, (int)this.supportedMarshallingStrategies.length);
            for (int i = 0; i < this.supportedMarshallingStrategies.length; ++i) {
                outputStream.writeUTF(this.supportedMarshallingStrategies[i]);
            }
        }
        finally {
            outputStream.close();
        }
    }

    public InjectedValue<ExecutorService> getExecutorService() {
        return this.executorService;
    }

    public Injector<DeploymentRepository> getDeploymentRepositoryInjector() {
        return this.deploymentRepositoryInjectedValue;
    }

    public Injector<EJBRemoteTransactionsRepository> getEJBRemoteTransactionsRepositoryInjector() {
        return this.ejbRemoteTransactionsRepositoryInjectedValue;
    }

    private boolean isSupportedMarshallingStrategy(String strategy) {
        return Arrays.asList(this.supportedMarshallingStrategies).contains(strategy);
    }

    private MarshallerFactory getMarshallerFactory(String marshallerStrategy) {
        MarshallerFactory marshallerFactory = Marshalling.getProvidedMarshallerFactory((String)marshallerStrategy);
        if (marshallerFactory == null) {
            throw new RuntimeException("Could not find a marshaller factory for " + marshallerStrategy + " marshalling strategy");
        }
        return marshallerFactory;
    }

    private class ClientVersionMessageReceiver
    implements Channel.Receiver {
        private final ServiceContainer serviceContainer;

        ClientVersionMessageReceiver(ServiceContainer serviceContainer) {
            this.serviceContainer = serviceContainer;
        }

        public void handleError(Channel channel, IOException error) {
            EjbLogger.EJB3_LOGGER.closingChannel(channel, error);
            try {
                channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void handleEnd(Channel channel) {
            EjbLogger.EJB3_LOGGER.closingChannelOnChannelEnd(channel);
            try {
                channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void handleMessage(Channel channel, MessageInputStream messageInputStream) {
            DataInputStream dataInputStream = new DataInputStream((InputStream)messageInputStream);
            try {
                byte version = dataInputStream.readByte();
                String clientMarshallingStrategy = dataInputStream.readUTF();
                log.debug((Object)("Client with protocol version " + version + " and marshalling strategy " + clientMarshallingStrategy + " trying to communicate on " + channel));
                if (!EJBRemoteConnectorService.this.isSupportedMarshallingStrategy(clientMarshallingStrategy)) {
                    EjbLogger.EJB3_LOGGER.unsupportedClientMarshallingStrategy(clientMarshallingStrategy, channel);
                    channel.close();
                    return;
                }
                switch (version) {
                    case 1: {
                        MarshallerFactory marshallerFactory = EJBRemoteConnectorService.this.getMarshallerFactory(clientMarshallingStrategy);
                        DeploymentRepository deploymentRepository = (DeploymentRepository)EJBRemoteConnectorService.this.deploymentRepositoryInjectedValue.getValue();
                        VersionOneProtocolChannelReceiver receiver = new VersionOneProtocolChannelReceiver(channel, deploymentRepository, (EJBRemoteTransactionsRepository)EJBRemoteConnectorService.this.ejbRemoteTransactionsRepositoryInjectedValue.getValue(), marshallerFactory, (ExecutorService)EJBRemoteConnectorService.this.executorService.getValue());
                        receiver.startReceiving();
                        return;
                    }
                    default: {
                        throw new RuntimeException("Cannot handle client version " + version);
                    }
                }
            }
            catch (IOException e) {
                log.errorf((Throwable)e, "Exception on channel %s from message %s", (Object)channel, (Object)messageInputStream);
                IoUtils.safeClose((Closeable)channel);
                return;
            }
            finally {
                IoUtils.safeClose((Closeable)messageInputStream);
            }
        }
    }

    private class ChannelOpenListener
    implements OpenListener {
        private final ServiceContainer serviceContainer;

        ChannelOpenListener(ServiceContainer serviceContainer) {
            this.serviceContainer = serviceContainer;
        }

        public void channelOpened(Channel channel) {
            log.tracef("Welcome %s to the jboss.ejb channel", (Object)channel);
            channel.addCloseHandler((CloseHandler)new CloseHandler<Channel>(){

                public void handleClose(Channel closed, IOException exception) {
                    log.tracef("channel %s closed", (Object)closed);
                }
            });
            try {
                EJBRemoteConnectorService.this.sendVersionMessage(channel);
            }
            catch (IOException e) {
                EjbLogger.EJB3_LOGGER.closingChannel(channel, e);
                IoUtils.safeClose((Closeable)channel);
            }
            channel.receiveMessage((Channel.Receiver)new ClientVersionMessageReceiver(this.serviceContainer));
        }

        public void registrationTerminated() {
        }
    }
}

