/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.web.deployment.TldsMetaData;
import org.jboss.metadata.parser.jsp.TldMetaDataParser;
import org.jboss.metadata.parser.util.NoopXMLResolver;
import org.jboss.metadata.web.spec.TldMetaData;
import org.jboss.vfs.VirtualFile;

public class TldParsingDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final String TLD = ".tld";
    private static final String META_INF = "META-INF";
    private static final String WEB_INF = "WEB-INF";
    private static final String CLASSES = "classes";
    private static final String LIB = "lib";
    private static final String IMPLICIT_TLD = "implicit.tld";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        VirtualFile deploymentRoot = ((ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot();
        TldsMetaData tldsMetaData = (TldsMetaData)deploymentUnit.getAttachment(TldsMetaData.ATTACHMENT_KEY);
        if (tldsMetaData == null) {
            tldsMetaData = new TldsMetaData();
            deploymentUnit.putAttachment(TldsMetaData.ATTACHMENT_KEY, (Object)tldsMetaData);
        }
        HashMap<String, TldMetaData> tlds = new HashMap<String, TldMetaData>();
        tldsMetaData.setTlds(tlds);
        List resourceRoots = (List)deploymentUnit.getAttachment(Attachments.RESOURCE_ROOTS);
        assert (resourceRoots != null);
        for (ResourceRoot resourceRoot : resourceRoots) {
            VirtualFile webFragment;
            if (!resourceRoot.getRoot().getLowerCaseName().endsWith(".jar") || !(webFragment = resourceRoot.getRoot().getChild(META_INF)).exists() || !webFragment.isDirectory()) continue;
            this.processTlds(deploymentRoot, webFragment.getChildren(), tlds);
        }
        VirtualFile webInf = deploymentRoot.getChild(WEB_INF);
        if (webInf.exists() && webInf.isDirectory()) {
            for (VirtualFile file : webInf.getChildren()) {
                if (file.isFile() && file.getLowerCaseName().endsWith(TLD)) {
                    tlds.put("/" + file.getPathNameRelativeTo(deploymentRoot), this.parseTLD(file));
                    continue;
                }
                if (!file.isDirectory() || CLASSES.equals(file.getName()) || LIB.equals(file.getName())) continue;
                this.processTlds(deploymentRoot, file.getChildren(), tlds);
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private void processTlds(VirtualFile root, List<VirtualFile> files, Map<String, TldMetaData> tlds) throws DeploymentUnitProcessingException {
        for (VirtualFile file : files) {
            if (file.isFile() && file.getLowerCaseName().endsWith(TLD)) {
                tlds.put("/" + file.getPathNameRelativeTo(root), this.parseTLD(file));
                continue;
            }
            if (!file.isDirectory()) continue;
            this.processTlds(root, file.getChildren(), tlds);
        }
    }

    private TldMetaData parseTLD(VirtualFile tld) throws DeploymentUnitProcessingException {
        if (IMPLICIT_TLD.equals(tld.getName())) {
            return new TldMetaData();
        }
        InputStream is = null;
        try {
            is = tld.openStream();
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setXMLResolver(NoopXMLResolver.create());
            XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(is);
            TldMetaData tldMetaData = TldMetaDataParser.parse((XMLStreamReader)xmlReader);
            return tldMetaData;
        }
        catch (XMLStreamException e) {
            throw new DeploymentUnitProcessingException("Failed to parse " + tld + " at [" + e.getLocation().getLineNumber() + "," + e.getLocation().getColumnNumber() + "]");
        }
        catch (IOException e) {
            throw new DeploymentUnitProcessingException("Failed to parse " + tld, (Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
    }
}

