/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.EnumSet;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.MessagingSubsystemProviders;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

class MessagingPathHandlers {
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{CommonAttributes.PATH, CommonAttributes.RELATIVE_TO};
    static final OperationStepHandler PATH_ADD = new OperationStepHandler(){

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
            ModelNode model = resource.getModel();
            for (AttributeDefinition def : ATTRIBUTES) {
                def.validateAndSet(operation, model);
            }
            MessagingPathHandlers.reloadRequiredStep(context);
            context.completeStep();
        }
    };
    static final OperationStepHandler PATH_ATTR = new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{CommonAttributes.RELATIVE_TO, CommonAttributes.PATH});
    static final OperationStepHandler PATH_REMOVE = new OperationStepHandler(){

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            Resource resource = context.removeResource(PathAddress.EMPTY_ADDRESS);
            MessagingPathHandlers.reloadRequiredStep(context);
            context.completeStep();
        }
    };

    MessagingPathHandlers() {
    }

    static void register(ManagementResourceRegistration registration) {
        registration.registerOperationHandler("add", PATH_ADD, MessagingSubsystemProviders.PATH_ADD);
        registration.registerOperationHandler("remove", PATH_REMOVE, MessagingSubsystemProviders.PATH_REMOVE);
        for (AttributeDefinition def : ATTRIBUTES) {
            registration.registerReadWriteAttribute(def.getName(), null, PATH_ATTR, EnumSet.of(AttributeAccess.Flag.RESTART_ALL_SERVICES));
        }
    }

    static ModelNode createAddOperation(ModelNode address, ModelNode subModel) {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        operation.get("address").set(address);
        operation.get("relative-to").set(subModel.get("relative-to"));
        operation.get("path").set(subModel.require("path"));
        return operation;
    }

    static void reloadRequiredStep(OperationContext context) {
        if (context.getType() == OperationContext.Type.SERVER) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceName hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
                    ServiceController controller = context.getServiceRegistry(false).getService(hqServiceName);
                    if (controller != null) {
                        context.reloadRequired();
                    }
                    context.completeStep();
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }
}

