/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc;

import org.jboss.as.cmp.jdbc.JDBCAbstractQueryCommand;
import org.jboss.as.cmp.jdbc.JDBCStoreManager;
import org.jboss.as.cmp.jdbc.QueryParameter;
import org.jboss.as.cmp.jdbc.SQLUtil;
import org.jboss.as.cmp.jdbc.bridge.JDBCCMPFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCEntityBridge;
import org.jboss.as.cmp.jdbc.metadata.JDBCQueryMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCReadAheadMetaData;

public final class JDBCFindByQuery
extends JDBCAbstractQueryCommand {
    private final JDBCCMPFieldBridge cmpField;

    public JDBCFindByQuery(JDBCStoreManager manager, JDBCQueryMetaData q) {
        super(manager, q);
        JDBCEntityBridge entity = (JDBCEntityBridge)manager.getEntityBridge();
        String finderName = q.getMethod().getName();
        String cmpFieldName = Character.toLowerCase(finderName.charAt(6)) + finderName.substring(7);
        this.cmpField = entity.getCMPFieldByName(cmpFieldName);
        if (this.cmpField == null) {
            throw new IllegalArgumentException("No finder for this method: " + finderName);
        }
        JDBCReadAheadMetaData readAhead = q.getReadAhead();
        if (readAhead.isOnFind()) {
            this.setEagerLoadGroup(readAhead.getEagerLoadGroup());
        }
        StringBuffer sql = new StringBuffer(300);
        sql.append("SELECT ");
        SQLUtil.getColumnNamesClause(entity.getPrimaryKeyFields(), sql);
        if (this.getEagerLoadGroup() != null) {
            SQLUtil.appendColumnNamesClause(entity, this.getEagerLoadGroup(), sql);
        }
        sql.append(" FROM ").append(entity.getQualifiedTableName()).append(" WHERE ");
        SQLUtil.getWhereClause(this.cmpField, sql);
        this.setSQL(sql.toString());
        this.setParameterList(QueryParameter.createParameters(0, this.cmpField));
    }
}

