/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

public enum CacheMode {
    LOCAL,
    REPL_SYNC,
    REPL_ASYNC,
    INVALIDATION_SYNC,
    INVALIDATION_ASYNC,
    DIST_SYNC,
    DIST_ASYNC;


    public boolean isInvalidation() {
        return this == INVALIDATION_SYNC || this == INVALIDATION_ASYNC;
    }

    public boolean isSynchronous() {
        return this == REPL_SYNC || this == DIST_SYNC || this == INVALIDATION_SYNC || this == LOCAL;
    }

    public boolean isClustered() {
        return this != LOCAL;
    }

    public boolean isDistributed() {
        return this == DIST_SYNC || this == DIST_ASYNC;
    }

    public boolean isReplicated() {
        return this == REPL_SYNC || this == REPL_ASYNC;
    }

    public CacheMode toSync() {
        switch (this) {
            case REPL_ASYNC: {
                return REPL_SYNC;
            }
            case INVALIDATION_ASYNC: {
                return INVALIDATION_SYNC;
            }
            case DIST_ASYNC: {
                return DIST_SYNC;
            }
        }
        return this;
    }

    public CacheMode toAsync() {
        switch (this) {
            case REPL_SYNC: {
                return REPL_ASYNC;
            }
            case INVALIDATION_SYNC: {
                return INVALIDATION_ASYNC;
            }
            case DIST_SYNC: {
                return DIST_ASYNC;
            }
        }
        return this;
    }
}

