/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.container.entries.AbstractInternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.TransientCacheValue;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.util.Util;

public class TransientCacheEntry
extends AbstractInternalCacheEntry {
    private TransientCacheValue cacheValue;

    TransientCacheEntry(Object key, Object value, EntryVersion version, long maxIdle) {
        this(key, value, version, maxIdle, System.currentTimeMillis());
    }

    TransientCacheEntry(Object key, Object value, EntryVersion version, long maxIdle, long lastUsed) {
        super(key);
        this.cacheValue = new TransientCacheValue(value, version, maxIdle, lastUsed);
    }

    @Override
    public Object getValue() {
        return this.cacheValue.value;
    }

    @Override
    public Object setValue(Object value) {
        return this.cacheValue.setValue(value);
    }

    @Override
    public EntryVersion getVersion() {
        return this.cacheValue.version;
    }

    @Override
    public void setVersion(EntryVersion version) {
        this.cacheValue.version = version;
    }

    @Override
    public final void touch() {
        this.cacheValue.lastUsed = System.currentTimeMillis();
    }

    @Override
    public final void reincarnate() {
    }

    @Override
    public final boolean canExpire() {
        return true;
    }

    @Override
    public boolean isExpired(long now) {
        return this.cacheValue.isExpired(now);
    }

    @Override
    public boolean isExpired() {
        return this.cacheValue.isExpired();
    }

    @Override
    public void setMaxIdle(long maxIdle) {
        this.cacheValue.maxIdle = maxIdle;
    }

    @Override
    public long getCreated() {
        return -1L;
    }

    @Override
    public final long getLastUsed() {
        return this.cacheValue.lastUsed;
    }

    @Override
    public long getLifespan() {
        return -1L;
    }

    @Override
    public long getExpiryTime() {
        return this.cacheValue.maxIdle > -1L ? this.cacheValue.lastUsed + this.cacheValue.maxIdle : -1L;
    }

    @Override
    public final long getMaxIdle() {
        return this.cacheValue.maxIdle;
    }

    @Override
    public InternalCacheValue toInternalCacheValue() {
        return this.cacheValue;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransientCacheEntry that = (TransientCacheEntry)o;
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        if (this.cacheValue.value != null ? !this.cacheValue.value.equals(that.cacheValue.value) : that.cacheValue.value != null) {
            return false;
        }
        if (this.cacheValue.lastUsed != that.cacheValue.lastUsed) {
            return false;
        }
        return this.cacheValue.maxIdle == that.cacheValue.maxIdle;
    }

    @Override
    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.cacheValue.value != null ? this.cacheValue.value.hashCode() : 0);
        result = 31 * result + (int)(this.cacheValue.lastUsed ^ this.cacheValue.lastUsed >>> 32);
        result = 31 * result + (int)(this.cacheValue.maxIdle ^ this.cacheValue.maxIdle >>> 32);
        return result;
    }

    @Override
    public TransientCacheEntry clone() {
        TransientCacheEntry clone = (TransientCacheEntry)super.clone();
        clone.cacheValue = this.cacheValue.clone();
        return clone;
    }

    @Override
    public String toString() {
        return "TransientCacheEntry{key=" + this.key + ", value=" + this.cacheValue + "}";
    }

    public static class Externalizer
    extends AbstractExternalizer<TransientCacheEntry> {
        @Override
        public void writeObject(ObjectOutput output, TransientCacheEntry tce) throws IOException {
            output.writeObject(tce.key);
            output.writeObject(((TransientCacheEntry)tce).cacheValue.value);
            output.writeObject(((TransientCacheEntry)tce).cacheValue.version);
            UnsignedNumeric.writeUnsignedLong(output, ((TransientCacheEntry)tce).cacheValue.lastUsed);
            output.writeLong(((TransientCacheEntry)tce).cacheValue.maxIdle);
        }

        @Override
        public TransientCacheEntry readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object k = input.readObject();
            Object v = input.readObject();
            EntryVersion version = (EntryVersion)input.readObject();
            long lastUsed = UnsignedNumeric.readUnsignedLong(input);
            Long maxIdle = input.readLong();
            return new TransientCacheEntry(k, v, version, maxIdle, lastUsed);
        }

        @Override
        public Integer getId() {
            return 12;
        }

        @Override
        public Set<Class<? extends TransientCacheEntry>> getTypeClasses() {
            return Util.asSet(TransientCacheEntry.class);
        }
    }
}

