/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.infinispan.CacheException;
import org.infinispan.config.Configuration;
import org.infinispan.config.ConfigurationException;
import org.infinispan.factories.AbstractComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.NamedComponentFactory;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.lifecycle.Lifecycle;
import org.infinispan.util.ReflectionUtil;
import org.infinispan.util.logging.Log;
import org.infinispan.util.reflect.AnnotatedMethodCache;
import org.infinispan.util.reflect.CachedMethod;

@SurvivesRestarts
@Scope(value=Scopes.NAMED_CACHE)
public abstract class AbstractComponentRegistry
implements Lifecycle,
Cloneable {
    private static final String DEPENDENCIES_ENABLE_JVMOPTION = "infinispan.debugDependencies";
    public static final boolean DEBUG_DEPENDENCIES = Boolean.getBoolean("infinispan.debugDependencies");
    private Stack<String> debugStack = DEBUG_DEPENDENCIES ? new Stack() : null;
    private Map<String, Class<? extends AbstractComponentFactory>> defaultFactories = null;
    private static final Object NULL_COMPONENT = new Object();
    private final Map<String, Component> componentLookup = new HashMap<String, Component>(1);
    protected volatile ComponentStatus state = ComponentStatus.INSTANTIATED;
    protected final ClassLoader defaultClassLoader;

    public ComponentStatus getStatus() {
        return this.state;
    }

    protected abstract Log getLog();

    protected AbstractComponentRegistry(ClassLoader classLoader) {
        this.defaultClassLoader = this.registerDefaultClassLoader(classLoader);
    }

    public void wireDependencies(Object target) throws ConfigurationException {
        try {
            List<CachedMethod> methods = AnnotatedMethodCache.getInjectMethods(target.getClass(), this.getClass().getClassLoader());
            for (CachedMethod method : methods) {
                this.invokeInjectionMethod(target, method);
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to configure component (type: " + target.getClass() + ", instance " + target + ")", e);
        }
    }

    public final void registerComponent(Object component, Class type) {
        this.registerComponent(component, type.getName());
    }

    public final void registerComponent(Object component, String name) {
        boolean survivesRestarts = ReflectionUtil.isAnnotationPresent(component.getClass(), SurvivesRestarts.class);
        this.registerComponentInternal(component, name, survivesRestarts);
    }

    protected final void registerNonVolatileComponent(Object component, String name) {
        this.registerComponentInternal(component, name, true);
    }

    protected final void registerNonVolatileComponent(Object component, Class type) {
        this.registerNonVolatileComponent(component, type.getName());
    }

    protected void registerComponentInternal(Object component, String name, boolean survivesRestarts) {
        Component c;
        if (component == null) {
            throw new NullPointerException("Cannot register a null component under name [" + name + "]");
        }
        Component old = this.componentLookup.get(name);
        if (old != null && old.instance.equals(component)) {
            this.getLog().tracef("Attempting to register a component equal to one that already exists under the same name (%s).  Not doing anything.", name);
            return;
        }
        if (old != null) {
            this.getLog().tracef("Replacing old component %s with new instance %s", old, component);
            old.instance = component;
            old.methodsScanned = false;
            c = old;
        } else {
            c = new Component();
            c.name = name;
            c.instance = component;
            this.componentLookup.put(name, c);
        }
        c.survivesRestarts = survivesRestarts;
        this.addComponentDependencies(c);
        c.injectDependencies();
        if (old == null) {
            this.getLog().tracef("Registering component %s under name %s", c, name);
        }
        if (this.state == ComponentStatus.RUNNING) {
            this.populateLifeCycleMethods(c);
        }
    }

    protected void addComponentDependencies(Component c) {
        Class<?> type = c.instance.getClass();
        c.injectionMethods = AnnotatedMethodCache.getInjectMethods(type, this.getClass().getClassLoader());
    }

    protected void invokeInjectionMethod(Object o, CachedMethod cam) {
        Class[] dependencies = cam.getParams();
        if (dependencies.length > 0) {
            Annotation[][] parameterAnnotations = cam.getParamAnnotations();
            Object[] params = new Object[dependencies.length];
            if (this.getLog().isTraceEnabled()) {
                this.getLog().tracef("Injecting dependencies for method [%s] on an instance of [%s].", cam.getReflectMethod(), o.getClass().getName());
            }
            for (int i = 0; i < dependencies.length; ++i) {
                params[i] = this.getOrCreateComponent(dependencies[i], this.getComponentName(dependencies[i], parameterAnnotations, i));
            }
            ReflectionUtil.invokeAccessibly(o, cam.getReflectMethod(), params);
        }
    }

    private String getComponentName(Class component, Annotation[][] annotations, int paramNumber) {
        String name;
        if (annotations == null || annotations.length <= paramNumber || (name = this.findComponentName(annotations[paramNumber])) == null) {
            return component.getName();
        }
        return name;
    }

    private String findComponentName(Annotation[] annotations) {
        if (annotations != null && annotations.length > 0) {
            for (Annotation a : annotations) {
                if (!(a instanceof ComponentName)) continue;
                return ((ComponentName)a).value();
            }
        }
        return null;
    }

    protected <T> T getOrCreateComponent(Class<T> componentClass) {
        return this.getOrCreateComponent(componentClass, componentClass.getName());
    }

    protected <T> T getOrCreateComponent(Class<T> componentClass, String name) {
        Object component;
        Component oldWrapper;
        if (DEBUG_DEPENDENCIES) {
            this.debugStack.push(name);
        }
        if ((oldWrapper = this.lookupComponent(componentClass, name)) != null) {
            component = this.unwrapComponent(oldWrapper);
        } else {
            AbstractComponentFactory factory = this.getFactory(componentClass);
            Object object = component = factory instanceof NamedComponentFactory ? ((NamedComponentFactory)factory).construct(componentClass, name) : factory.construct(componentClass);
            if (component != null) {
                this.registerComponent(component, name);
            } else {
                this.getLog().tracef("Registering a null for component %s", name);
                this.registerNullComponent(name);
            }
        }
        if (DEBUG_DEPENDENCIES) {
            this.debugStack.pop();
        }
        return (T)component;
    }

    protected AbstractComponentFactory getFactory(Class componentClass) {
        AbstractComponentFactory cf;
        Map<String, Class<? extends AbstractComponentFactory>> defaultFactoryMap = this.getDefaultFactoryMap();
        Class<? extends AbstractComponentFactory> cfClass = defaultFactoryMap.get(componentClass.getName());
        if (cfClass == null) {
            this.throwStackAwareConfigurationException("No registered default factory for component '" + componentClass + "' found!");
        }
        if ((cf = this.getComponent(cfClass)) == null) {
            cf = this.instantiateFactory(cfClass);
            if (cf == null) {
                this.throwStackAwareConfigurationException("Unable to locate component factory for component " + componentClass);
            }
            this.registerComponent((Object)cf, cfClass);
        }
        Component c = this.lookupComponent(cfClass, cfClass.getName());
        if (c.instance != cf) {
            this.throwStackAwareConfigurationException("Component factory " + cfClass + " incorrectly registered!");
        }
        return cf;
    }

    protected Component lookupComponent(Class type, String componentName) {
        return this.componentLookup.get(componentName);
    }

    protected Map<String, Class<? extends AbstractComponentFactory>> getDefaultFactoryMap() {
        if (this.defaultFactories == null) {
            this.scanDefaultFactories();
        }
        return this.defaultFactories;
    }

    void scanDefaultFactories() {
        HashMap<String, Class<? extends AbstractComponentFactory>> temp = new HashMap<String, Class<? extends AbstractComponentFactory>>();
        Map<String, String[]> factories = AnnotatedMethodCache.getDefaultFactories();
        for (Map.Entry<String, String[]> factoryEntry : factories.entrySet()) {
            boolean factoryValid = true;
            Class<?> factory = null;
            try {
                factory = this.getClass().getClassLoader().loadClass(factoryEntry.getKey());
                if (AutoInstantiableFactory.class.isAssignableFrom(factory) && factory.getConstructor(new Class[0]) == null) {
                    factoryValid = false;
                }
            }
            catch (Exception e) {
                factoryValid = false;
            }
            if (!factoryValid) {
                throw new RuntimeException("Factory class " + factory + " implements AutoInstantiableFactory but does not expose a public, no-arg constructor!  Debug stack: " + this.debugStack);
            }
            for (String buildableClass : factoryEntry.getValue()) {
                temp.put(buildableClass, factory);
            }
        }
        this.defaultFactories = temp;
    }

    AbstractComponentFactory instantiateFactory(Class<? extends AbstractComponentFactory> factory) {
        if (AutoInstantiableFactory.class.isAssignableFrom(factory)) {
            try {
                return factory.newInstance();
            }
            catch (Exception e) {
                throw new ConfigurationException("Unable to instantiate factory " + factory + "  Debug stack: " + this.debugStack, e);
            }
        }
        throw new ConfigurationException("Cannot auto-instantiate factory " + factory + " as it doesn't implement " + AutoInstantiableFactory.class.getSimpleName() + "!  Debug stack: " + this.debugStack);
    }

    protected final void registerNullComponent(String name) {
        this.registerComponent(NULL_COMPONENT, name);
    }

    protected Configuration getConfiguration() {
        return this.getComponent(Configuration.class);
    }

    public <T> T getComponent(Class<T> type) {
        return this.getComponent(type, type.getName());
    }

    public <T> T getComponent(Class<T> type, String name) {
        Component wrapper = this.lookupComponent(type, name);
        if (wrapper == null) {
            return null;
        }
        return (T)this.unwrapComponent(wrapper);
    }

    private Object unwrapComponent(Component wrapper) {
        return wrapper.instance == NULL_COMPONENT ? null : wrapper.instance;
    }

    private ClassLoader registerDefaultClassLoader(ClassLoader loader) {
        ClassLoader loaderToUse = loader == null ? this.getClass().getClassLoader() : loader;
        this.registerComponent((Object)loaderToUse, ClassLoader.class);
        this.componentLookup.get((Object)ClassLoader.class.getName()).survivesRestarts = true;
        return loaderToUse;
    }

    public void rewire() {
        for (Component c : new HashSet<Component>(this.componentLookup.values())) {
            c.injectDependencies();
        }
    }

    private void populateLifecycleMethods() {
        for (Component c : this.componentLookup.values()) {
            this.populateLifeCycleMethods(c);
        }
    }

    private void populateLifeCycleMethods(Component c) {
        if (!c.methodsScanned) {
            PrioritizedMethod em;
            c.methodsScanned = true;
            c.startMethods.clear();
            c.stopMethods.clear();
            Class<?> componentClass = c.instance.getClass();
            for (CachedMethod m : AnnotatedMethodCache.getStartMethods(componentClass, this.getClass().getClassLoader())) {
                em = new PrioritizedMethod();
                em.component = c;
                em.method = m;
                em.priority = m.getAnnotationValueAsInt("priority");
                c.startMethods.add(em);
            }
            for (CachedMethod m : AnnotatedMethodCache.getStopMethods(componentClass, this.getClass().getClassLoader())) {
                em = new PrioritizedMethod();
                em.component = c;
                em.method = m;
                em.priority = m.getAnnotationValueAsInt("priority");
                c.stopMethods.add(em);
            }
        }
    }

    public void resetVolatileComponents() {
        for (Component c : new HashSet<Component>(this.componentLookup.values())) {
            if (c.survivesRestarts) continue;
            this.componentLookup.remove(c.name);
        }
        if (this.getLog().isTraceEnabled()) {
            this.getLog().tracef("Reset volatile components. Registry now contains %s", this.componentLookup.keySet());
        }
    }

    @Override
    public void start() {
        if (!this.state.startAllowed()) {
            if (this.state.needToDestroyFailedCache()) {
                this.destroy();
            }
            if (this.state.needToInitializeBeforeStart()) {
                this.rewire();
            } else {
                return;
            }
        }
        this.state = ComponentStatus.INITIALIZING;
        try {
            this.internalStart();
        }
        catch (Throwable t) {
            this.handleLifecycleTransitionFailure(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (!this.state.stopAllowed()) {
            this.getLog().debugf("Ignoring call to stop() as current state is %s", this);
            return;
        }
        boolean failed = this.state == ComponentStatus.FAILED;
        try {
            this.internalStop();
        }
        catch (Throwable t) {
            if (failed) {
                this.getLog().failedToCallStopAfterFailure(t);
            }
            failed = true;
            this.handleLifecycleTransitionFailure(t);
        }
        finally {
            if (!failed) {
                this.state = ComponentStatus.TERMINATED;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroy() {
        try {
            if (this.state.stopAllowed()) {
                this.stop();
            }
        }
        catch (CacheException e) {
            this.getLog().stopBeforeDestroyFailed(e);
        }
        try {
            this.resetVolatileComponents();
        }
        finally {
            this.state = ComponentStatus.TERMINATED;
        }
    }

    private void handleLifecycleTransitionFailure(Throwable t) {
        this.state = ComponentStatus.FAILED;
        if (t.getCause() != null && t.getCause() instanceof ConfigurationException) {
            throw (ConfigurationException)t.getCause();
        }
        if (t.getCause() != null && t.getCause() instanceof InvocationTargetException && t.getCause().getCause() != null && t.getCause().getCause() instanceof ConfigurationException) {
            throw (ConfigurationException)t.getCause().getCause();
        }
        if (t instanceof CacheException) {
            throw (CacheException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new CacheException(t);
    }

    private void internalStart() throws CacheException, IllegalArgumentException {
        this.populateLifecycleMethods();
        ArrayList<PrioritizedMethod> startMethods = new ArrayList<PrioritizedMethod>(this.componentLookup.size());
        for (Component c : this.componentLookup.values()) {
            startMethods.addAll(c.startMethods);
        }
        Collections.sort(startMethods);
        boolean traceEnabled = this.getLog().isTraceEnabled();
        for (PrioritizedMethod em : startMethods) {
            if (traceEnabled) {
                this.getLog().tracef("Invoking start method %s on component %s", em.method, em.component.getName());
            }
            em.invoke();
        }
        this.addShutdownHook();
        this.state = ComponentStatus.RUNNING;
    }

    protected void addShutdownHook() {
    }

    protected void removeShutdownHook() {
    }

    private void internalStop() {
        this.state = ComponentStatus.STOPPING;
        this.removeShutdownHook();
        ArrayList<PrioritizedMethod> stopMethods = new ArrayList<PrioritizedMethod>(this.componentLookup.size());
        for (Component c : this.componentLookup.values()) {
            stopMethods.addAll(c.stopMethods);
        }
        Collections.sort(stopMethods);
        boolean traceEnabled = this.getLog().isTraceEnabled();
        for (PrioritizedMethod em : stopMethods) {
            if (traceEnabled) {
                this.getLog().tracef("Invoking stop method %s on component %s", em.method, em.component.getName());
            }
            em.invoke();
        }
        this.destroy();
    }

    public boolean invocationsAllowed(boolean originLocal) {
        this.getLog().trace("Testing if invocations are allowed.");
        if (this.state.allowInvocations()) {
            return true;
        }
        if (originLocal) {
            return false;
        }
        this.getLog().trace("Is remotely originating.");
        if (this.state == ComponentStatus.INITIALIZING) {
            this.getLog().trace("Cache is initializing; block.");
            try {
                this.blockUntilCacheStarts();
                return true;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        } else {
            this.getLog().cacheNotStarted();
        }
        return false;
    }

    private void blockUntilCacheStarts() throws InterruptedException, IllegalStateException {
        int pollFrequencyMS = 100;
        long startupWaitTime = this.getConfiguration().getStateRetrievalTimeout();
        long giveUpTime = System.currentTimeMillis() + startupWaitTime;
        while (System.currentTimeMillis() < giveUpTime && !this.state.allowInvocations()) {
            Thread.sleep(pollFrequencyMS);
        }
        if (!this.state.allowInvocations()) {
            throw new IllegalStateException("Cache not in STARTED state, even after waiting " + this.getConfiguration().getStateRetrievalTimeout() + " millis.");
        }
    }

    public Set<Component> getRegisteredComponents() {
        HashSet<Component> defensiveCopy = new HashSet<Component>(this.componentLookup.values());
        return Collections.unmodifiableSet(defensiveCopy);
    }

    public AbstractComponentRegistry clone() throws CloneNotSupportedException {
        AbstractComponentRegistry dolly = (AbstractComponentRegistry)super.clone();
        dolly.state = ComponentStatus.INSTANTIATED;
        return dolly;
    }

    private void throwStackAwareConfigurationException(String message) {
        if (this.debugStack == null) {
            throw new ConfigurationException(message + ". To get more detail set the system property " + DEPENDENCIES_ENABLE_JVMOPTION + " to true");
        }
        throw new ConfigurationException(message + " Debug stack: " + this.debugStack);
    }

    static class PrioritizedMethod
    implements Comparable<PrioritizedMethod> {
        CachedMethod method;
        Component component;
        int priority;

        PrioritizedMethod() {
        }

        @Override
        public int compareTo(PrioritizedMethod o) {
            return this.priority < o.priority ? -1 : (this.priority == o.priority ? 0 : 1);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PrioritizedMethod)) {
                return false;
            }
            PrioritizedMethod that = (PrioritizedMethod)o;
            if (this.priority != that.priority) {
                return false;
            }
            if (this.component != null ? !this.component.equals(that.component) : that.component != null) {
                return false;
            }
            return !(this.method != null ? !this.method.equals(that.method) : that.method != null);
        }

        public int hashCode() {
            int result = this.method != null ? this.method.hashCode() : 0;
            result = 31 * result + (this.component != null ? this.component.hashCode() : 0);
            result = 31 * result + this.priority;
            return result;
        }

        void invoke() {
            ReflectionUtil.invokeAccessibly(this.component.instance, this.method.getReflectMethod(), null);
        }

        public String toString() {
            return "PrioritizedMethod{method=" + this.method + ", priority=" + this.priority + '}';
        }
    }

    public class Component {
        Object instance;
        String name;
        boolean methodsScanned;
        List<CachedMethod> injectionMethods;
        List<PrioritizedMethod> startMethods = new ArrayList<PrioritizedMethod>(2);
        List<PrioritizedMethod> stopMethods = new ArrayList<PrioritizedMethod>(2);
        boolean survivesRestarts;

        public String toString() {
            return "Component{instance=" + this.instance + ", name=" + this.name + ", survivesRestarts=" + this.survivesRestarts + '}';
        }

        public void injectDependencies() {
            for (CachedMethod m : this.injectionMethods) {
                AbstractComponentRegistry.this.invokeInjectionMethod(this.instance, m);
            }
        }

        public Object getInstance() {
            return this.instance;
        }

        public String getName() {
            return this.name;
        }
    }
}

