/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.jboss;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.infinispan.marshall.jboss.ExtendedRiverMarshaller;
import org.infinispan.marshall.jboss.ExtendedRiverUnmarshaller;
import org.jboss.marshalling.AbstractMarshallerFactory;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.reflect.SerializableClassRegistry;
import org.jboss.marshalling.river.RiverMarshallerFactory;

public class JBossMarshallerFactory
extends AbstractMarshallerFactory {
    private final SerializableClassRegistry registry;
    private final RiverMarshallerFactory factory = (RiverMarshallerFactory)Marshalling.getMarshallerFactory((String)"river", (ClassLoader)Marshalling.class.getClassLoader());

    public JBossMarshallerFactory() {
        if (this.factory == null) {
            throw new IllegalStateException("River marshaller factory not found.  Verify that the JBoss Marshalling River jar archive is in the classpath.");
        }
        this.registry = AccessController.doPrivileged(new PrivilegedAction<SerializableClassRegistry>(){

            @Override
            public SerializableClassRegistry run() {
                return SerializableClassRegistry.getInstance();
            }
        });
    }

    public Unmarshaller createUnmarshaller(MarshallingConfiguration configuration) throws IOException {
        return new ExtendedRiverUnmarshaller(this.factory, this.registry, configuration);
    }

    public Marshaller createMarshaller(MarshallingConfiguration configuration) throws IOException {
        return new ExtendedRiverMarshaller(this.factory, this.registry, configuration);
    }
}

