/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.Collection;
import java.util.List;
import org.infinispan.CacheException;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.context.Flag;
import org.infinispan.context.impl.NonTxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashHelper;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.loaders.CacheStore;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.BaseStateTransferManagerImpl;
import org.infinispan.statetransfer.BaseStateTransferTask;
import org.infinispan.statetransfer.DistributedStateTransferTask;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="DistributedStateTransferManager", description="Component that handles state transfer in distributed mode")
public class DistributedStateTransferManagerImpl
extends BaseStateTransferManagerImpl {
    private static final Log log = LogFactory.getLog(DistributedStateTransferManagerImpl.class);
    private DistributionManager dm;

    @Inject
    public void init(DistributionManager dm) {
        this.dm = dm;
    }

    @Override
    protected BaseStateTransferTask createStateTransferTask(int viewId, List<Address> members, boolean initialView) {
        return new DistributedStateTransferTask(this.rpcManager, this.configuration, this.dataContainer, this, this.dm, this.stateTransferLock, this.cacheNotifier, viewId, members, this.chOld, this.chNew, initialView);
    }

    @Override
    protected ConsistentHash createConsistentHash(List<Address> members) {
        return ConsistentHashHelper.createConsistentHash(this.configuration, members);
    }

    public void invalidateKeys(List<Object> keysToRemove, int viewId) {
        try {
            if (keysToRemove.size() > 0) {
                InvalidateCommand invalidateCmd = this.cf.buildInvalidateFromL1Command(true, keysToRemove);
                NonTxInvocationContext ctx = this.icc.createNonTxInvocationContext();
                ctx.setFlags(Flag.CACHE_MODE_LOCAL, Flag.SKIP_LOCKING);
                this.interceptorChain.invoke(ctx, invalidateCmd);
                log.debugf("Invalidated %d keys, data container now has %d keys", keysToRemove.size(), this.dataContainer.size());
                log.tracef("Invalidated keys: %s", keysToRemove);
            }
        }
        catch (CacheException e) {
            log.failedToInvalidateKeys(e);
        }
    }

    @Override
    public CacheStore getCacheStoreForStateTransfer() {
        if (this.cacheLoaderManager == null || !this.cacheLoaderManager.isEnabled() || this.cacheLoaderManager.isShared()) {
            return null;
        }
        return this.cacheLoaderManager.getCacheStore();
    }

    @Override
    public boolean isLocationInDoubt(Object key) {
        return this.isStateTransferInProgress() && !this.chOld.locate(key, this.configuration.getNumOwners()).contains(this.getAddress()) && this.chNew.locate(key, this.configuration.getNumOwners()).contains(this.getAddress());
    }

    @Override
    public void updateLeavers(Collection<Address> leavers) {
        super.updateLeavers(leavers);
        this.dm.setLeavers(leavers);
    }
}

