/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Set;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.util.Util;

public class ByteArrayKey
implements Serializable {
    private static final long serialVersionUID = 7305972805432411725L;
    private final byte[] data;

    public ByteArrayKey(byte[] data) {
        this.data = data;
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ByteArrayKey key = (ByteArrayKey)obj;
        return Arrays.equals(key.data, this.data);
    }

    public int hashCode() {
        return 41 + Arrays.hashCode(this.data);
    }

    public String toString() {
        return "ByteArrayKey" + "{" + "data=" + Util.printArray(this.data, true) + "}";
    }

    public static class Externalizer
    extends AbstractExternalizer<ByteArrayKey> {
        @Override
        public void writeObject(ObjectOutput output, ByteArrayKey key) throws IOException {
            output.writeInt(key.data.length);
            output.write(key.data);
        }

        @Override
        public ByteArrayKey readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            byte[] data = new byte[input.readInt()];
            input.readFully(data);
            return new ByteArrayKey(data);
        }

        @Override
        public Integer getId() {
            return 57;
        }

        @Override
        public Set<Class<? extends ByteArrayKey>> getTypeClasses() {
            return Util.asSet(ByteArrayKey.class);
        }
    }
}

