/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller;

import org.jboss.as.controller.RunningMode;
import org.jboss.as.domain.controller.DomainControllerMessages;

public class SlaveRegistrationException
extends Exception {
    private static final String SEPARATOR = "-$-";
    private final ErrorCode errorCode;
    private final String errorMessage;

    public SlaveRegistrationException(ErrorCode errorCode, String errorMessage) {
        super(errorMessage);
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public static SlaveRegistrationException parse(String raw) {
        int index = raw.indexOf(SEPARATOR);
        if (index == -1) {
            return new SlaveRegistrationException(ErrorCode.NONE, raw);
        }
        ErrorCode code = ErrorCode.parseCode(Integer.valueOf(raw.substring(0, index)));
        String msg = raw.substring(index + SEPARATOR.length());
        return new SlaveRegistrationException(code, msg);
    }

    public static SlaveRegistrationException forUnknownError(String msg) {
        return new SlaveRegistrationException(ErrorCode.NONE, msg);
    }

    public static SlaveRegistrationException forHostAlreadyExists(String slaveName) {
        return new SlaveRegistrationException(ErrorCode.HOST_ALREADY_EXISTS, DomainControllerMessages.MESSAGES.slaveAlreadyRegistered(slaveName));
    }

    public static SlaveRegistrationException forMasterInAdminOnlyMode(RunningMode runningMode) {
        return new SlaveRegistrationException(ErrorCode.MASTER_IS_ADMIN_ONLY, DomainControllerMessages.MESSAGES.adminOnlyModeCannotAcceptSlaves(runningMode));
    }

    public static SlaveRegistrationException forHostIsNotMaster() {
        return new SlaveRegistrationException(ErrorCode.HOST_ALREADY_EXISTS, DomainControllerMessages.MESSAGES.slaveControllerCannotAcceptOtherSlaves());
    }

    public String marshal() {
        return this.errorCode.getCode() + SEPARATOR + this.errorMessage;
    }

    @Override
    public String toString() {
        return this.errorCode.getCode() + SEPARATOR + this.errorMessage;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public static enum ErrorCode {
        NONE(0),
        HOST_ALREADY_EXISTS(1),
        MASTER_IS_ADMIN_ONLY(2),
        HOST_IS_NOT_MASTER(3);

        private final int code;

        private ErrorCode(int code) {
            this.code = code;
        }

        int getCode() {
            return this.code;
        }

        static ErrorCode parseCode(int code) {
            if (code == NONE.getCode()) {
                return NONE;
            }
            if (code == HOST_ALREADY_EXISTS.getCode()) {
                return HOST_ALREADY_EXISTS;
            }
            if (code == MASTER_IS_ADMIN_ONLY.getCode()) {
                return MASTER_IS_ADMIN_ONLY;
            }
            if (code == HOST_IS_NOT_MASTER.getCode()) {
                return HOST_IS_NOT_MASTER;
            }
            throw DomainControllerMessages.MESSAGES.invalidCode(code);
        }
    }
}

