/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.coordination;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.domain.controller.DomainControllerMessages;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.as.domain.controller.operations.coordination.DomainOperationContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class DomainFinalResultHandler
implements OperationStepHandler {
    private final DomainOperationContext domainOperationContext;

    public DomainFinalResultHandler(DomainOperationContext domainOperationContext) {
        this.domainOperationContext = domainOperationContext;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.completeStep();
        boolean isDomain = this.isDomainOperation(operation);
        boolean shouldContinue = !this.collectDomainFailure(context, isDomain);
        shouldContinue = shouldContinue && !this.collectContextFailure(context, isDomain);
        boolean bl = shouldContinue = shouldContinue && !this.collectHostFailures(context, isDomain);
        if (shouldContinue) {
            if (this.domainOperationContext.getServerResults().size() == 0) {
                context.getResult().set(this.getSingleHostResult());
            } else {
                this.populateServerGroupResults(context, context.getResult());
            }
        }
    }

    private boolean collectDomainFailure(OperationContext context, boolean isDomain) {
        ModelNode coordinator = this.domainOperationContext.getCoordinatorResult();
        ModelNode domainFailure = null;
        if (isDomain && coordinator != null && coordinator.has("failure-description")) {
            ModelNode modelNode = domainFailure = coordinator.hasDefined("failure-description") ? coordinator.get("failure-description") : new ModelNode().set(DomainControllerMessages.MESSAGES.unexplainedFailure());
        }
        if (domainFailure != null) {
            context.getFailureDescription().get("domain-failure-description").set(domainFailure);
            return true;
        }
        return false;
    }

    private boolean collectContextFailure(OperationContext context, boolean isDomain) {
        if (!this.domainOperationContext.isFailureReported() && context.hasFailureDescription()) {
            ModelNode formattedFailure = new ModelNode();
            if (isDomain) {
                ModelNode failure = context.getFailureDescription();
                if (failure.isDefined()) {
                    formattedFailure.get("domain-failure-description").set(failure);
                } else {
                    formattedFailure.get("domain-failure-description").set(DomainControllerMessages.MESSAGES.unexplainedFailure());
                }
            } else {
                ModelNode hostFailureProperty = new ModelNode();
                ModelNode contextFailure = context.getFailureDescription();
                ModelNode hostFailure = contextFailure.isDefined() ? contextFailure : new ModelNode().set(DomainControllerMessages.MESSAGES.unexplainedFailure());
                hostFailureProperty.add(this.domainOperationContext.getLocalHostInfo().getLocalHostName(), hostFailure);
                formattedFailure.get("host-failure-descriptions").set(hostFailureProperty);
            }
            context.getFailureDescription().set(formattedFailure);
            return true;
        }
        return false;
    }

    private boolean collectHostFailures(OperationContext context, boolean isDomain) {
        ModelNode hostFailureResults = null;
        for (Map.Entry<String, ModelNode> entry : this.domainOperationContext.getHostControllerResults().entrySet()) {
            ModelNode hostResult = entry.getValue();
            if (!hostResult.has("failure-description")) continue;
            if (hostFailureResults == null) {
                hostFailureResults = new ModelNode();
            }
            ModelNode desc = hostResult.hasDefined("failure-description") ? hostResult.get("failure-description") : new ModelNode().set(DomainControllerMessages.MESSAGES.unexplainedFailure());
            hostFailureResults.add(entry.getKey(), desc);
        }
        ModelNode coordinator = this.domainOperationContext.getCoordinatorResult();
        if (!isDomain && coordinator != null && coordinator.has("failure-description")) {
            if (hostFailureResults == null) {
                hostFailureResults = new ModelNode();
            }
            ModelNode desc = coordinator.hasDefined("failure-description") ? coordinator.get("failure-description") : new ModelNode().set(DomainControllerMessages.MESSAGES.unexplainedFailure());
            hostFailureResults.add(this.domainOperationContext.getLocalHostInfo().getLocalHostName(), desc);
        }
        if (hostFailureResults != null) {
            context.getFailureDescription().get("host-failure-descriptions").set(hostFailureResults);
            return true;
        }
        return false;
    }

    private ModelNode getSingleHostResult() {
        ModelNode singleHost = this.domainOperationContext.getCoordinatorResult();
        if (singleHost != null && (!singleHost.hasDefined("result") || ModelType.STRING == singleHost.get("result").getType() && "ignored-by-unaffected-host-controller".equals(singleHost.get("result").asString()))) {
            singleHost = null;
        }
        if (singleHost == null) {
            for (ModelNode node : this.domainOperationContext.getHostControllerResults().values()) {
                if (!node.hasDefined("result") || "ignored-by-unaffected-host-controller".equals(node.get("result").asString())) continue;
                singleHost = node;
                break;
            }
        }
        return singleHost == null ? new ModelNode() : singleHost.get("result");
    }

    private void populateServerGroupResults(OperationContext context, ModelNode result) {
        TreeSet<String> groupNames = new TreeSet<String>();
        HashMap groupToServerMap = new HashMap();
        for (Map.Entry<ServerIdentity, ModelNode> entry : this.domainOperationContext.getServerResults().entrySet()) {
            String serverGroup = entry.getKey().getServerGroupName();
            groupNames.add(serverGroup);
            String hostName = entry.getKey().getHostName();
            String serverName = entry.getKey().getServerName();
            if (!groupToServerMap.containsKey(serverGroup)) {
                groupToServerMap.put(serverGroup, new TreeSet());
            }
            ((Set)groupToServerMap.get(serverGroup)).add(new HostServer(hostName, serverName, entry.getValue()));
        }
        boolean serverGroupSuccess = false;
        for (String groupName : groupNames) {
            ModelNode groupNode = new ModelNode();
            if (!this.domainOperationContext.isServerGroupRollback(groupName)) {
                serverGroupSuccess = true;
            }
            for (HostServer hostServer : (Set)groupToServerMap.get(groupName)) {
                ModelNode serverNode = new ModelNode();
                serverNode.get("host").set(hostServer.hostName);
                serverNode.get("response").set(hostServer.result);
                groupNode.get(hostServer.serverName).set(serverNode);
            }
            result.get(new String[]{"server-groups", groupName}).set(groupNode);
        }
        if (!serverGroupSuccess) {
            context.getFailureDescription().set(DomainControllerMessages.MESSAGES.operationFailedOrRolledBack());
        }
    }

    private boolean isDomainOperation(ModelNode operation) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        return address.size() == 0 || !address.getElement(0).getKey().equals("host");
    }

    private class HostServer
    implements Comparable<HostServer> {
        private final String hostName;
        private final String serverName;
        private final ModelNode result;

        private HostServer(String hostName, String serverName, ModelNode result) {
            this.hostName = hostName;
            this.serverName = serverName;
            this.result = result;
        }

        @Override
        public int compareTo(HostServer hostServer) {
            int hostCompare = this.hostName.compareTo(hostServer.hostName);
            if (hostCompare != 0) {
                return hostCompare;
            }
            return this.serverName.compareTo(hostServer.serverName);
        }
    }
}

