/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.jbws;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.jboss.ws.WSException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.deployment.ReferenceFactory;
import org.jboss.wsf.spi.deployment.InstanceProvider;
import org.jboss.wsf.spi.deployment.Reference;

final class NativeInstanceProvider
implements InstanceProvider {
    private static final ResourceBundle bundle = BundleUtils.getBundle(NativeInstanceProvider.class);
    private final ClassLoader loader;
    private final Map<String, Reference> cache = new HashMap<String, Reference>();

    NativeInstanceProvider(ClassLoader loader) {
        this.loader = loader;
    }

    public synchronized Reference getInstance(String className) {
        Reference instance = this.cache.get(className);
        if (instance == null) {
            try {
                instance = ReferenceFactory.newUninitializedReference(this.loader.loadClass(className).newInstance());
                this.cache.put(className, instance);
            }
            catch (Exception e) {
                throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_LOAD_CLASS", (Object[])new Object[]{className}), e);
            }
        }
        return instance;
    }
}

